/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.spi.message.PostDspRequest;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/catalog")
public class DspCatalogApiController {
    private final CatalogProtocolService service;
    private final DspRequestHandler dspRequestHandler;

    public DspCatalogApiController(CatalogProtocolService service, DspRequestHandler dspRequestHandler) {
        this.service = service;
        this.dspRequestHandler = dspRequestHandler;
    }

    @POST
    @Path(value="/request")
    public Response requestCatalog(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(CatalogRequestMessage.class, Catalog.class).token(token)).expectedMessageType("https://w3id.org/dspace/v0.8/CatalogRequestMessage").message(jsonObject).serviceCall((arg_0, arg_1) -> ((CatalogProtocolService)this.service).getCatalog(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/CatalogError")).build();
        return this.dspRequestHandler.createResource(request);
    }

    @GET
    @Path(value="/datasets/{id}")
    public Response getDataset(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(Dataset.class).token(token)).id(id).serviceCall((arg_0, arg_1) -> ((CatalogProtocolService)this.service).getDataset(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/CatalogError")).build();
        return this.dspRequestHandler.getResource(request);
    }
}

