/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.api;

import org.eclipse.edc.catalog.spi.DataService;
import org.eclipse.edc.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.protocol.dsp.catalog.api.controller.DspCatalogApiController;
import org.eclipse.edc.protocol.dsp.catalog.api.controller.DspCatalogApiController20241;
import org.eclipse.edc.protocol.dsp.catalog.api.validation.CatalogRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.spi.configuration.DspApiConfiguration;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.version.DspVersions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Catalog Extension")
public class DspCatalogApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Catalog Extension";
    @Inject
    private WebService webService;
    @Inject
    private DspApiConfiguration apiConfiguration;
    @Inject
    private CatalogProtocolService service;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private CriterionOperatorRegistry criterionOperatorRegistry;
    @Inject
    private ProtocolVersionRegistry versionRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/CatalogRequestMessage", CatalogRequestMessageValidator.instance(this.criterionOperatorRegistry));
        this.webService.registerResource(this.apiConfiguration.getContextAlias(), (Object)new DspCatalogApiController(this.service, this.dspRequestHandler));
        this.webService.registerResource(this.apiConfiguration.getContextAlias(), (Object)new DspCatalogApiController20241(this.service, this.dspRequestHandler));
        this.dataServiceRegistry.register(DataService.Builder.newInstance().terms("connector").endpointUrl(this.apiConfiguration.getDspCallbackAddress()).build());
        this.versionRegistry.register(DspVersions.V_2024_1);
    }
}

