/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.jsonld.spi.TypeUtil;
import org.eclipse.edc.protocol.dsp.api.configuration.error.DspErrorResponse;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/catalog")
public class DspCatalogApiController {
    private final Monitor monitor;
    private final IdentityService identityService;
    private final TypeTransformerRegistry transformerRegistry;
    private final String dspCallbackAddress;
    private final CatalogProtocolService service;

    public DspCatalogApiController(Monitor monitor, IdentityService identityService, TypeTransformerRegistry transformerRegistry, String dspCallbackAddress, CatalogProtocolService service) {
        this.monitor = monitor;
        this.identityService = identityService;
        this.transformerRegistry = transformerRegistry;
        this.dspCallbackAddress = dspCallbackAddress;
        this.service = service;
    }

    @POST
    @Path(value="/request")
    public Response requestCatalog(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        this.monitor.debug(() -> "DSP: Incoming catalog request.", new Throwable[0]);
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        Result verificationResult = this.identityService.verifyJwtToken(tokenRepresentation, this.dspCallbackAddress);
        if (verificationResult.failed()) {
            this.monitor.debug(String.format("Unauthorized, %s", verificationResult.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().unauthorized();
        }
        if (!TypeUtil.isOfExpectedType((JsonObject)jsonObject, (String)"https://w3id.org/dspace/v0.8/CatalogRequestMessage")) {
            this.monitor.debug(String.format("Bad Request, %s", verificationResult.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().badRequest();
        }
        Result transformResult = this.transformerRegistry.transform((Object)jsonObject, CatalogRequestMessage.class);
        if (transformResult.failed()) {
            this.monitor.debug(String.format("Bad Request, %s", verificationResult.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().badRequest();
        }
        CatalogRequestMessage message = (CatalogRequestMessage)transformResult.getContent();
        message.setProtocol("dataspace-protocol-http");
        ClaimToken claimToken = (ClaimToken)verificationResult.getContent();
        ServiceResult catalog = this.service.getCatalog(message, claimToken);
        if (catalog.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error returning catalog, error id %s: %s", errorCode, catalog.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().message(String.format("Error code %s", errorCode)).from((ServiceFailure)catalog.getFailure());
        }
        Result catalogJson = this.transformerRegistry.transform((Object)((Catalog)catalog.getContent()), JsonObject.class);
        if (catalogJson.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error transforming catalog, error id %s: %s", errorCode, catalogJson.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().message(String.format("Error code %s", errorCode)).internalServerError();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(catalogJson.getContent()).build();
    }

    @GET
    @Path(value="/datasets/{id}")
    public Response getDataset(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        Result verificationResult = this.identityService.verifyJwtToken(tokenRepresentation, this.dspCallbackAddress);
        if (verificationResult.failed()) {
            this.monitor.debug(String.format("Unauthorized, %s", verificationResult.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().unauthorized();
        }
        ServiceResult datasetResult = this.service.getDataset(id, (ClaimToken)verificationResult.getContent());
        if (datasetResult.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error returning dataset, error id %s: %s", errorCode, datasetResult.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().message(String.format("Error code %s", errorCode)).from((ServiceFailure)datasetResult.getFailure());
        }
        Result datasetJson = this.transformerRegistry.transform((Object)((Dataset)datasetResult.getContent()), JsonObject.class);
        if (datasetJson.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error transforming dataset, error id %s: %s", errorCode, datasetJson.getFailureMessages()), new Throwable[0]);
            return DspCatalogApiController.error().message(String.format("Error code %s", errorCode)).internalServerError();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(datasetJson.getContent()).build();
    }

    @NotNull
    private static DspErrorResponse error() {
        return DspErrorResponse.type((String)"https://w3id.org/dspace/v0.8/CatalogError");
    }
}

