/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.api;

import org.eclipse.edc.catalog.spi.DataService;
import org.eclipse.edc.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.protocol.dsp.api.configuration.DspApiConfiguration;
import org.eclipse.edc.protocol.dsp.catalog.api.controller.DspCatalogApiController;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Catalog Extension")
public class DspCatalogApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Catalog Extension";
    @Inject
    private WebService webService;
    @Inject
    private IdentityService identityService;
    @Inject
    private DspApiConfiguration apiConfiguration;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private CatalogProtocolService service;
    @Inject
    private DataServiceRegistry dataServiceRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String dspCallbackAddress = this.apiConfiguration.getDspCallbackAddress();
        DspCatalogApiController catalogController = new DspCatalogApiController(context.getMonitor(), this.identityService, this.transformerRegistry, dspCallbackAddress, this.service);
        this.webService.registerResource(this.apiConfiguration.getContextAlias(), (Object)catalogController);
        this.dataServiceRegistry.register(DataService.Builder.newInstance().terms("connector").endpointUrl(this.apiConfiguration.getDspCallbackAddress()).build());
    }
}

