/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.api.configuration.message;

import jakarta.json.JsonObject;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.edc.protocol.dsp.api.configuration.error.DspErrorResponse;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.spi.message.PostDspRequest;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.message.ProcessRemoteMessage;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;

public class DspRequestHandlerImpl
implements DspRequestHandler {
    private final Monitor monitor;
    private final String callbackAddress;
    private final IdentityService identityService;
    private final JsonObjectValidatorRegistry validatorRegistry;
    private final TypeTransformerRegistry transformerRegistry;

    public DspRequestHandlerImpl(Monitor monitor, String callbackAddress, IdentityService identityService, JsonObjectValidatorRegistry validatorRegistry, TypeTransformerRegistry transformerRegistry) {
        this.monitor = monitor;
        this.callbackAddress = callbackAddress;
        this.identityService = identityService;
        this.validatorRegistry = validatorRegistry;
        this.transformerRegistry = transformerRegistry;
    }

    public <R> Response getResource(GetDspRequest<R> request) {
        this.monitor.debug(() -> "DSP: Incoming resource request for %s id %s".formatted(request.getResultClass(), request.getId()), new Throwable[0]);
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(request.getToken()).build();
        Result claimTokenResult = this.identityService.verifyJwtToken(tokenRepresentation, this.callbackAddress);
        if (claimTokenResult.failed()) {
            this.monitor.debug(() -> "DSP: Unauthorized: %s".formatted(claimTokenResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).unauthorized();
        }
        ServiceResult serviceResult = (ServiceResult)request.getServiceCall().apply(request.getId(), (ClaimToken)claimTokenResult.getContent());
        if (serviceResult.failed()) {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(serviceResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getId()).from((ServiceFailure)serviceResult.getFailure());
        }
        Object resource = serviceResult.getContent();
        Result transformation = this.transformerRegistry.transform(resource, JsonObject.class);
        if (transformation.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning("Error transforming %s, error id %s: %s".formatted(request.getResultClass().getSimpleName(), errorCode, transformation.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getId()).message(String.format("Error code %s", errorCode)).internalServerError();
        }
        return Response.ok().type("application/json").entity(transformation.getContent()).build();
    }

    public <I extends RemoteMessage, R> Response createResource(PostDspRequest<I, R> request) {
        this.monitor.debug(() -> "DSP: Incoming %s for %s process%s".formatted(request.getInputClass().getSimpleName(), request.getResultClass(), request.getProcessId() != null ? ": " + request.getProcessId() : ""), new Throwable[0]);
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(request.getToken()).build();
        Result claimTokenResult = this.identityService.verifyJwtToken(tokenRepresentation, this.callbackAddress);
        if (claimTokenResult.failed()) {
            this.monitor.debug(() -> "DSP: Unauthorized: %s".formatted(claimTokenResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).unauthorized();
        }
        ValidationResult validation = this.validatorRegistry.validate(request.getExpectedMessageType(), request.getMessage());
        if (validation.failed()) {
            this.monitor.debug(() -> "DSP: Validation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).badRequest();
        }
        Result inputTransformation = (Result)this.transformerRegistry.transform((Object)request.getMessage(), request.getInputClass()).compose(message -> {
            if (message instanceof ProcessRemoteMessage) {
                ProcessRemoteMessage processRemoteMessage = (ProcessRemoteMessage)message;
                processRemoteMessage.setProtocol("dataspace-protocol-http");
            }
            return Result.success((Object)message);
        });
        if (inputTransformation.failed()) {
            this.monitor.debug(() -> "DSP: Transformation failed: %s".formatted(inputTransformation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).badRequest();
        }
        ServiceResult serviceResult = (ServiceResult)request.getServiceCall().apply((RemoteMessage)inputTransformation.getContent(), (ClaimToken)claimTokenResult.getContent());
        if (serviceResult.failed()) {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(serviceResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).from((ServiceFailure)serviceResult.getFailure());
        }
        Object resource = serviceResult.getContent();
        Result outputTransformation = this.transformerRegistry.transform(resource, JsonObject.class);
        if (outputTransformation.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning("Error transforming %s, error id %s: %s".formatted(request.getResultClass().getSimpleName(), errorCode, outputTransformation.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).message("Error code %s".formatted(errorCode)).internalServerError();
        }
        return Response.ok().type("application/json").entity(outputTransformation.getContent()).build();
    }

    public <I extends RemoteMessage, R> Response updateResource(PostDspRequest<I, R> request) {
        this.monitor.debug(() -> "DSP: Incoming %s for %s process%s".formatted(request.getInputClass().getSimpleName(), request.getResultClass(), request.getProcessId() != null ? ": " + request.getProcessId() : ""), new Throwable[0]);
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(request.getToken()).build();
        Result claimTokenResult = this.identityService.verifyJwtToken(tokenRepresentation, this.callbackAddress);
        if (claimTokenResult.failed()) {
            this.monitor.debug(() -> "DSP: Unauthorized: %s".formatted(claimTokenResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getProcessId()).unauthorized();
        }
        ValidationResult validation = this.validatorRegistry.validate(request.getExpectedMessageType(), request.getMessage());
        if (validation.failed()) {
            this.monitor.debug(() -> "DSP: Validation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getProcessId()).badRequest();
        }
        Result inputTransformation = (Result)this.transformerRegistry.transform((Object)request.getMessage(), request.getInputClass()).compose(message -> {
            if (message instanceof ProcessRemoteMessage) {
                ProcessRemoteMessage processRemoteMessage = (ProcessRemoteMessage)message;
                processRemoteMessage.setProtocol("dataspace-protocol-http");
                return Objects.equals(request.getProcessId(), processRemoteMessage.getProcessId()) ? Result.success((Object)message) : Result.failure((String)"DSP: Invalid process ID. Expected: %s, actual: %s".formatted(request.getProcessId(), processRemoteMessage.getProcessId()));
            }
            return Result.success((Object)message);
        });
        if (inputTransformation.failed()) {
            this.monitor.debug(() -> "DSP: Transformation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getProcessId()).badRequest();
        }
        return (Response)((ServiceResult)request.getServiceCall().apply((RemoteMessage)inputTransformation.getContent(), (ClaimToken)claimTokenResult.getContent())).map(it -> Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build()).orElse(failure -> {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(failure.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type(request.getErrorType()).processId(request.getProcessId()).from((ServiceFailure)failure);
        });
    }
}

