/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.core.transform.transformer.OdrlTransformersFactory;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromCatalogTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromDataAddressTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromDataServiceTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromDatasetTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromDistributionTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.core.transform.transformer.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToCatalogTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToDataAddressTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToDataServiceTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToDatasetTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToDistributionTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.protocol.dsp.api.configuration.DspApiConfiguration;
import org.eclipse.edc.protocol.dsp.api.configuration.message.DspRequestHandlerImpl;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.jersey.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Extension(value="Dataspace Protocol API Configuration Extension")
@Provides(value={DspApiConfiguration.class, ProtocolWebhook.class, DspRequestHandler.class})
public class DspApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol API Configuration Extension";
    public static final String CONTEXT_ALIAS = "protocol";
    public static final String DEFAULT_DSP_CALLBACK_ADDRESS = "http://localhost:8282/api/v1/dsp";
    public static final String DSP_CALLBACK_ADDRESS = "edc.dsp.callback.address";
    public static final int DEFAULT_PROTOCOL_PORT = 8282;
    public static final String DEFAULT_PROTOCOL_API_PATH = "/api/v1/dsp";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.protocol").contextAlias("protocol").defaultPath("/api/v1/dsp").defaultPort(8282).name("Protocol API").build();
    @Inject
    private TypeManager typeManager;
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private IdentityService identityService;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration config = this.configurator.configure(context, this.webServer, SETTINGS);
        String dspWebhookAddress = context.getSetting(DSP_CALLBACK_ADDRESS, DEFAULT_DSP_CALLBACK_ADDRESS);
        context.registerService(DspApiConfiguration.class, (Object)new DspApiConfiguration(config.getContextAlias(), dspWebhookAddress));
        context.registerService(ProtocolWebhook.class, () -> dspWebhookAddress);
        context.registerService(DspRequestHandler.class, (Object)new DspRequestHandlerImpl(context.getMonitor(), dspWebhookAddress, this.identityService, this.validatorRegistry, this.transformerRegistry));
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.webService.registerResource(config.getContextAlias(), (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource(config.getContextAlias(), (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper));
        this.registerTransformers();
    }

    private void registerTransformers() {
        ObjectMapper mapper = this.typeManager.getMapper("json-ld");
        mapper.registerSubtypes(new Class[]{AtomicConstraint.class, LiteralExpression.class});
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromCatalogTransformer(jsonBuilderFactory, mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromDatasetTransformer(jsonBuilderFactory, mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(jsonBuilderFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromDistributionTransformer(jsonBuilderFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromDataServiceTransformer(jsonBuilderFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromAssetTransformer(jsonBuilderFactory, mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(jsonBuilderFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(jsonBuilderFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(jsonBuilderFactory, mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToCatalogTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToDataServiceTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToDatasetTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToDistributionTransformer());
        OdrlTransformersFactory.jsonObjectToOdrlTransformers().forEach(arg_0 -> ((TypeTransformerRegistry)this.transformerRegistry).register(arg_0));
        this.transformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressTransformer());
    }
}

