/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.util.sink;

import java.util.concurrent.ExecutorService;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.util.sink.OutputStreamDataSink;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class OutputStreamDataSinkFactory
implements DataSinkFactory {
    public static final String TYPE = "OutputStream";
    private final Monitor monitor;
    private final ExecutorService executorService;

    public OutputStreamDataSinkFactory(Monitor monitor, ExecutorService executorService) {
        this.monitor = monitor;
        this.executorService = executorService;
    }

    public boolean canHandle(DataFlowRequest request) {
        return TYPE.equals(request.getDestinationDataAddress().getType());
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        if (!this.canHandle(request)) {
            return Result.failure((String)String.format("%s: Cannot handle destination data address with type: %s", this.getClass().getSimpleName(), request.getDestinationDataAddress().getType()));
        }
        return Result.success();
    }

    public DataSink createSink(DataFlowRequest request) {
        return new OutputStreamDataSink(request.getId(), this.executorService, this.monitor);
    }
}

