/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.util.validation;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.spi.result.Result;

public interface ValidationRule<T>
extends Function<T, Result<Void>> {
    public static <T> ValidationRule<T> identity() {
        return t -> Result.success();
    }

    default public ValidationRule<T> and(ValidationRule<T> other) {
        return t -> {
            Stream otherFailureMessages;
            Result thisResult = (Result)this.apply(t);
            Result otherResult = (Result)other.apply(t);
            Stream<Object> thisFailureMessages = thisResult.failed() ? thisResult.getFailureMessages().stream() : Stream.empty();
            List totalFailureMessages = Stream.concat(thisFailureMessages, otherFailureMessages = otherResult.failed() ? otherResult.getFailureMessages().stream() : Stream.empty()).collect(Collectors.toList());
            if (totalFailureMessages.isEmpty()) {
                return Result.success();
            }
            return Result.failure(totalFailureMessages);
        };
    }
}

