/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.util.sink;

import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class OutputStreamDataSinkFactory
implements DataSinkFactory {
    public static final String TYPE = "OutputStream";

    public boolean canHandle(DataFlowRequest request) {
        return TYPE.equals(request.getDestinationDataAddress().getType());
    }

    @NotNull
    public Result<Boolean> validate(DataFlowRequest request) {
        return (Result)this.validateRequest(request).map(it -> true);
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        if (!this.canHandle(request)) {
            return Result.failure((String)String.format("%s: Cannot handle destination data address with type: %s", this.getClass().getSimpleName(), request.getDestinationDataAddress().getType()));
        }
        return Result.success();
    }

    public DataSink createSink(DataFlowRequest request) {
        return source -> CompletableFuture.completedFuture(StreamResult.success());
    }
}

