/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.util.sink;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamFailure;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.util.async.AsyncUtils;

public class OutputStreamDataSink
implements DataSink {
    private final String requestId;
    private final OutputStream stream;
    private final ExecutorService executorService;
    private final Monitor monitor;

    public OutputStreamDataSink(String requestId, OutputStream stream, ExecutorService executorService, Monitor monitor) {
        this.requestId = requestId;
        this.stream = stream;
        this.executorService = executorService;
        this.monitor = monitor;
    }

    public CompletableFuture<StreamResult<Void>> transfer(DataSource source) {
        CompletionStage completionStage;
        block9: {
            StreamResult streamResult = source.openPartStream();
            if (streamResult.failed()) {
                return CompletableFuture.completedFuture(StreamResult.failure((StreamFailure)((StreamFailure)streamResult.getFailure())));
            }
            Stream partStream = (Stream)streamResult.getContent();
            try {
                completionStage = ((CompletableFuture)partStream.map(part -> CompletableFuture.supplyAsync(() -> this.transferData((DataSource.Part)part), this.executorService)).collect(AsyncUtils.asyncAllOf())).thenApply(results -> {
                    if (results.stream().anyMatch(AbstractResult::failed)) {
                        return StreamResult.error((String)"Error transferring data");
                    }
                    return StreamResult.success();
                });
                if (partStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (partStream != null) {
                        try {
                            partStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errorMessage = String.format("Error processing data transfer request - Request ID: %s", this.requestId);
                    this.monitor.severe(errorMessage, new Throwable[]{e});
                    return CompletableFuture.completedFuture(StreamResult.error((String)errorMessage));
                }
            }
            partStream.close();
        }
        return completionStage;
    }

    private Result<Void> transferData(DataSource.Part part) {
        Result result;
        block8: {
            InputStream source = part.openStream();
            try {
                source.transferTo(this.stream);
                result = Result.success();
                if (source == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.monitor.severe("Error writing data", new Throwable[]{e});
                    return Result.failure((String)"Error writing data");
                }
            }
            source.close();
        }
        return result;
    }
}

