/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.spi.pipeline;

import java.util.Collections;
import java.util.List;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamFailure;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Failure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamResult<T>
extends AbstractResult<T, StreamFailure, StreamResult<T>> {
    protected StreamResult(T content, StreamFailure failure) {
        super(content, (Failure)failure);
    }

    public static <T> StreamResult<T> success(T content) {
        return new StreamResult<T>(content, null);
    }

    public static <T> StreamResult<T> notFound() {
        return new StreamResult<Object>(null, new StreamFailure(Collections.emptyList(), StreamFailure.Reason.NOT_FOUND));
    }

    public static <T> StreamResult<T> notAuthorized() {
        return new StreamResult<Object>(null, new StreamFailure(Collections.emptyList(), StreamFailure.Reason.NOT_AUTHORIZED));
    }

    public static <T> StreamResult<T> error(String message) {
        return new StreamResult<Object>(null, new StreamFailure(List.of(message), StreamFailure.Reason.GENERAL_ERROR));
    }

    public static <T> StreamResult<T> success() {
        return StreamResult.success(null);
    }

    public static <T> StreamResult<T> failure(StreamFailure failure) {
        return new StreamResult<Object>(null, failure);
    }

    public StreamFailure.Reason reason() {
        return ((StreamFailure)this.getFailure()).getReason();
    }

    @NotNull
    protected <R1 extends AbstractResult<C1, StreamFailure, R1>, C1> R1 newInstance(@Nullable C1 content, @Nullable StreamFailure failure) {
        return (R1)((Object)new StreamResult<C1>(content, failure));
    }
}

