/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.edc.connector.dataplane.spi.DataFlowStates;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.TransferType;
import org.jetbrains.annotations.Nullable;

public class DataFlow
extends StatefulEntity<DataFlow> {
    public static final String TERMINATION_REASON = "terminationReason";
    private DataAddress source;
    private DataAddress destination;
    private URI callbackAddress;
    private Map<String, String> properties = new HashMap<String, String>();
    private TransferType transferType;
    private String runtimeId;

    public DataFlow copy() {
        Builder builder = Builder.newInstance().source(this.source).destination(this.destination).callbackAddress(this.callbackAddress).properties(this.properties).transferType(this.getTransferType()).runtimeId(this.runtimeId);
        return (DataFlow)this.copy(builder);
    }

    public String stateAsString() {
        return DataFlowStates.from(this.state).name();
    }

    public DataAddress getSource() {
        return this.source;
    }

    public DataAddress getDestination() {
        return this.destination;
    }

    public URI getCallbackAddress() {
        return this.callbackAddress;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public DataFlowStartMessage toRequest() {
        return DataFlowStartMessage.Builder.newInstance().id(this.getId()).sourceDataAddress(this.getSource()).destinationDataAddress(this.getDestination()).processId(this.getId()).callbackAddress(this.getCallbackAddress()).traceContext(this.traceContext).properties(this.getProperties()).transferType(this.getTransferType()).build();
    }

    public void transitToCompleted() {
        this.transitionTo(DataFlowStates.COMPLETED.code());
    }

    public void transitToReceived() {
        this.transitionTo(DataFlowStates.RECEIVED.code());
    }

    public void transitToFailed(String message) {
        this.errorDetail = message;
        this.transitionTo(DataFlowStates.FAILED.code());
    }

    public void transitToNotified() {
        this.transitionTo(DataFlowStates.NOTIFIED.code());
    }

    public void transitToTerminated(@Nullable String reason) {
        this.transitionTo(DataFlowStates.TERMINATED.code());
        if (reason != null) {
            this.properties.put(TERMINATION_REASON, reason);
        }
    }

    public void transitionToStarted(String runtimeId) {
        this.runtimeId = runtimeId;
        this.transitionTo(DataFlowStates.STARTED.code());
    }

    public void transitToSuspended() {
        this.transitionTo(DataFlowStates.SUSPENDED.code());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends StatefulEntity.Builder<DataFlow, Builder> {
        private Builder(DataFlow process) {
            super((StatefulEntity)process);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder(new DataFlow());
        }

        public Builder self() {
            return this;
        }

        public DataFlow build() {
            super.build();
            if (((DataFlow)this.entity).id == null) {
                ((DataFlow)this.entity).id = UUID.randomUUID().toString();
            }
            return (DataFlow)this.entity;
        }

        public Builder source(DataAddress source) {
            ((DataFlow)this.entity).source = source;
            return this;
        }

        public Builder destination(DataAddress destination) {
            ((DataFlow)this.entity).destination = destination;
            return this;
        }

        public Builder callbackAddress(URI callbackAddress) {
            ((DataFlow)this.entity).callbackAddress = callbackAddress;
            return this;
        }

        public Builder transferType(TransferType transferType) {
            ((DataFlow)this.entity).transferType = transferType;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            ((DataFlow)this.entity).properties = new HashMap<String, String>(properties);
            return this;
        }

        public Builder runtimeId(String runtimeId) {
            ((DataFlow)this.entity).runtimeId = runtimeId;
            return this;
        }
    }
}

