/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.signaling.transform.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Optional;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.FlowType;
import org.eclipse.edc.spi.types.domain.transfer.TransferType;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataFlowStartMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, DataFlowStartMessage> {
    public JsonObjectToDataFlowStartMessageTransformer() {
        super(JsonObject.class, DataFlowStartMessage.class);
    }

    @Nullable
    public DataFlowStartMessage transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        DataFlowStartMessage.Builder builder = DataFlowStartMessage.Builder.newInstance();
        JsonValue transferTypeDestination = (JsonValue)object.get((Object)"https://w3id.org/edc/v0.0.1/ns/transferTypeDestination");
        JsonValue flowType = (JsonValue)object.get((Object)"https://w3id.org/edc/v0.0.1/ns/flowType");
        if (transferTypeDestination == null || flowType == null) {
            ((MissingPropertyBuilder)context.problem().missingProperty().property("%s - %s".formatted("https://w3id.org/edc/v0.0.1/ns/transferTypeDestination", "https://w3id.org/edc/v0.0.1/ns/flowType"))).report();
            return null;
        }
        builder.transferType(new TransferType(this.transformString(transferTypeDestination, context), FlowType.valueOf((String)this.transformString(flowType, context))));
        this.visitProperties(object, (s, jsonValue) -> this.transformProperties((String)s, (JsonValue)jsonValue, builder, context));
        return builder.build();
    }

    private void transformProperties(String key, JsonValue jsonValue, DataFlowStartMessage.Builder builder, TransformerContext context) {
        switch (key) {
            case "https://w3id.org/edc/v0.0.1/ns/processId": {
                builder.processId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/agreementId": {
                builder.agreementId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/datasetId": {
                builder.assetId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/callbackAddress": {
                Optional.ofNullable(this.transformString(jsonValue, context)).map(URI::create).ifPresent(arg_0 -> ((DataFlowStartMessage.Builder)builder).callbackAddress(arg_0));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/properties": {
                JsonObject props = jsonValue.asJsonArray().getJsonObject(0);
                this.visitProperties(props, (k, val) -> this.transformProperties((String)k, (JsonValue)val, builder, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/participantId": {
                builder.participantId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/destinationDataAddress": {
                builder.destinationDataAddress((DataAddress)this.transformObject(jsonValue, DataAddress.class, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/sourceDataAddress": {
                builder.sourceDataAddress((DataAddress)this.transformObject(jsonValue, DataAddress.class, context));
                break;
            }
            default: {
                builder.property(key, this.transformString(jsonValue, context));
            }
        }
    }
}

