/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.signaling.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataFlowStartMessageTransformer
extends AbstractJsonLdTransformer<DataFlowStartMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonObjectFromDataFlowStartMessageTransformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(DataFlowStartMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull DataFlowStartMessage message, @NotNull TransformerContext context) {
        JsonObjectBuilder propertiesBuilder = this.jsonFactory.createObjectBuilder();
        this.transformProperties(message.getProperties(), propertiesBuilder, this.typeManager.getMapper(this.typeContext), context);
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@type", "https://w3id.org/edc/v0.0.1/ns/DataFlowStartMessage").add("https://w3id.org/edc/v0.0.1/ns/transferTypeDestination", message.getTransferType().destinationType()).add("https://w3id.org/edc/v0.0.1/ns/flowType", message.getTransferType().flowType().toString()).add("https://w3id.org/edc/v0.0.1/ns/agreementId", message.getAgreementId()).add("https://w3id.org/edc/v0.0.1/ns/processId", message.getProcessId()).add("https://w3id.org/edc/v0.0.1/ns/datasetId", message.getAssetId()).add("https://w3id.org/edc/v0.0.1/ns/properties", propertiesBuilder).add("https://w3id.org/edc/v0.0.1/ns/callbackAddress", message.getCallbackAddress().toString()).add("https://w3id.org/edc/v0.0.1/ns/sourceDataAddress", (JsonValue)context.transform((Object)message.getSourceDataAddress(), JsonObject.class)).add("https://w3id.org/edc/v0.0.1/ns/participantId", message.getParticipantId());
        if (message.getDestinationDataAddress() != null) {
            builder.add("https://w3id.org/edc/v0.0.1/ns/destinationDataAddress", (JsonValue)context.transform((Object)message.getDestinationDataAddress(), JsonObject.class));
        }
        if (message.getTransferType().responseChannelType() != null) {
            builder.add("https://w3id.org/edc/v0.0.1/ns/responseChannel", message.getTransferType().responseChannelType());
        }
        return builder.build();
    }
}

