/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.eclipse.edc.connector.dataplane.client.DataPlaneSignalingClient;
import org.eclipse.edc.connector.dataplane.client.EmbeddedDataPlaneClient;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.http.spi.ControlApiHttpClient;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Data Plane Signaling Client")
public class DataPlaneSignalingClientExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane Signaling Client";
    @Inject(required=false)
    private ControlApiHttpClient httpClient;
    @Inject
    private TypeManager typeManager;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private JsonLd jsonLd;
    @Inject(required=false)
    private DataPlaneManager dataPlaneManager;

    public String name() {
        return NAME;
    }

    @Provider
    public DataPlaneClientFactory dataPlaneClientFactory(ServiceExtensionContext context) {
        if (this.dataPlaneManager != null) {
            context.getMonitor().debug(() -> "Using embedded Data Plane client.", new Throwable[0]);
            return instance -> new EmbeddedDataPlaneClient(this.dataPlaneManager);
        }
        ObjectMapper mapper = this.typeManager.getMapper("json-ld");
        context.getMonitor().debug(() -> "Using remote Data Plane client.", new Throwable[0]);
        Objects.requireNonNull(this.httpClient, "To use remote Data Plane client, a ControlApiHttpClient instance must be registered");
        TypeTransformerRegistry signalingApiTypeTransformerRegistry = this.transformerRegistry.forContext("signaling-api");
        return instance -> new DataPlaneSignalingClient(this.httpClient, signalingApiTypeTransformerRegistry, this.jsonLd, mapper, instance);
    }
}

