/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Objects;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowProvisionMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowResponseMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;

public class EmbeddedDataPlaneClient
implements DataPlaneClient {
    private final DataPlaneManager dataPlaneManager;

    public EmbeddedDataPlaneClient(DataPlaneManager dataPlaneManager) {
        this.dataPlaneManager = Objects.requireNonNull(dataPlaneManager, "Data plane manager");
    }

    public StatusResult<DataFlowResponseMessage> provision(DataFlowProvisionMessage request) {
        Result provisioning = this.dataPlaneManager.provision(request);
        if (provisioning.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)provisioning.getFailureDetail());
        }
        return StatusResult.success((Object)((DataFlowResponseMessage)provisioning.getContent()));
    }

    @WithSpan
    public StatusResult<DataFlowResponseMessage> start(DataFlowStartMessage request) {
        Result result = this.dataPlaneManager.validate(request);
        if (result.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)result.getFailureDetail());
        }
        Result startResult = this.dataPlaneManager.start(request);
        if (startResult.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)startResult.getFailureDetail());
        }
        return StatusResult.success((Object)((DataFlowResponseMessage)startResult.getContent()));
    }

    public StatusResult<Void> suspend(String transferProcessId) {
        return this.dataPlaneManager.suspend(transferProcessId);
    }

    public StatusResult<Void> terminate(String transferProcessId) {
        return this.dataPlaneManager.terminate(transferProcessId);
    }

    public StatusResult<Void> checkAvailability() {
        return StatusResult.success();
    }
}

