/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.api.signaling.transform.from.JsonObjectFromDataFlowStartMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.from.JsonObjectFromDataFlowSuspendMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.from.JsonObjectFromDataFlowTerminateMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.to.JsonObjectToDataFlowResponseMessageTransformer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.dspace.from.JsonObjectFromDataAddressDspaceTransformer;
import org.eclipse.edc.transform.transformer.dspace.to.JsonObjectToDataAddressDspaceTransformer;

@Extension(value="Data Plane Signaling transform Client")
public class DataPlaneSignalingClientTransformExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane Signaling transform Client";
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry signalingApiTransformerRegistry = this.transformerRegistry.forContext("signaling-api");
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataFlowStartMessageTransformer(factory, this.typeManager, "json-ld"));
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataFlowSuspendMessageTransformer(factory));
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataFlowTerminateMessageTransformer(factory));
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataFlowResponseMessageTransformer());
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressDspaceTransformer());
        signalingApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressDspaceTransformer(factory, this.typeManager, "json-ld"));
    }
}

