/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.http.spi.ControlApiHttpClient;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowProvisionMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowResponseMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowSuspendMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowTerminateMessage;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.NotNull;

public class DataPlaneSignalingClient
implements DataPlaneClient {
    public static final MediaType TYPE_JSON = MediaType.parse((String)"application/json");
    private final ControlApiHttpClient httpClient;
    private final String typeContext;
    private final DataPlaneInstance dataPlane;
    private final TypeTransformerRegistry transformerRegistry;
    private final JsonLd jsonLd;
    private final String jsonLdScope;
    private final TypeManager typeManager;

    public DataPlaneSignalingClient(ControlApiHttpClient httpClient, TypeTransformerRegistry transformerRegistry, JsonLd jsonLd, String jsonLdScope, TypeManager typeManager, String typeContext, DataPlaneInstance dataPlane) {
        this.httpClient = httpClient;
        this.transformerRegistry = transformerRegistry;
        this.jsonLd = jsonLd;
        this.jsonLdScope = jsonLdScope;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
        this.dataPlane = dataPlane;
    }

    @NotNull
    private static <T> StatusResult<T> failedResult(String processId, ServiceFailure failure) {
        return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Transfer request for process %s failed: %s", processId, failure.getFailureDetail()));
    }

    public StatusResult<DataFlowResponseMessage> provision(DataFlowProvisionMessage message) {
        return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)"remote data flow preparation not implemented yet.");
    }

    @WithSpan
    public StatusResult<DataFlowResponseMessage> start(DataFlowStartMessage message) {
        String url = this.dataPlane.getUrl().toString();
        return (StatusResult)this.createRequestBuilder(message, url).compose(builder -> (StatusResult)this.httpClient.request(builder).flatMap(result -> (StatusResult)result.map(this::handleStartResponse).orElse(failure -> DataPlaneSignalingClient.failedResult(message.getProcessId(), failure))));
    }

    public StatusResult<Void> suspend(String transferProcessId) {
        String url = "%s/%s/suspend".formatted(this.dataPlane.getUrl(), transferProcessId);
        DataFlowSuspendMessage message = DataFlowSuspendMessage.Builder.newInstance().build();
        return (StatusResult)this.createRequestBuilder(message, url).compose(builder -> (StatusResult)this.httpClient.request(builder).flatMap(result -> (StatusResult)result.map(it -> StatusResult.success()).orElse(failure -> DataPlaneSignalingClient.failedResult(transferProcessId, failure))));
    }

    public StatusResult<Void> terminate(String transferProcessId) {
        String url = "%s/%s/terminate".formatted(this.dataPlane.getUrl(), transferProcessId);
        DataFlowTerminateMessage message = DataFlowTerminateMessage.Builder.newInstance().build();
        return (StatusResult)this.createRequestBuilder(message, url).compose(builder -> (StatusResult)this.httpClient.request(builder).flatMap(result -> (StatusResult)result.map(it -> StatusResult.success()).orElse(failure -> DataPlaneSignalingClient.failedResult(transferProcessId, failure))));
    }

    public StatusResult<Void> checkAvailability() {
        Request.Builder requestBuilder = new Request.Builder().get().url(String.valueOf(this.dataPlane.getUrl()) + "/check");
        return (StatusResult)this.httpClient.request(requestBuilder).flatMap(result -> (StatusResult)result.map(it -> StatusResult.success()).orElse(failure -> DataPlaneSignalingClient.failedResult(null, failure)));
    }

    private StatusResult<Request.Builder> createRequestBuilder(Object message, String url) {
        return (StatusResult)((Result)((Result)this.transformerRegistry.transform(message, JsonObject.class).compose(this::compact)).compose(this::serializeMessage)).map(rawBody -> RequestBody.create((String)rawBody, (MediaType)TYPE_JSON)).map(body -> new Request.Builder().post(body).url(url)).flatMap(it -> {
            if (it.succeeded()) {
                return StatusResult.success((Object)((Request.Builder)it.getContent()));
            }
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)it.getFailureDetail());
        });
    }

    private StatusResult<DataFlowResponseMessage> handleStartResponse(String responseBody) {
        return Optional.ofNullable(responseBody).map(this::deserializeStartMessage).orElseGet(() -> StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)"Body missing"));
    }

    private StatusResult<DataFlowResponseMessage> deserializeStartMessage(String responseBody) {
        try {
            JsonObject jsonObject = (JsonObject)this.typeManager.getMapper(this.typeContext).readValue(responseBody, JsonObject.class);
            Result result = (Result)this.jsonLd.expand(jsonObject).compose(expanded -> this.transformerRegistry.transform(expanded, DataFlowResponseMessage.class));
            if (result.succeeded()) {
                return StatusResult.success((Object)((DataFlowResponseMessage)result.getContent()));
            }
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)result.getFailureDetail());
        }
        catch (IOException e) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)e.getMessage());
        }
    }

    private Result<JsonObject> compact(JsonObject object) {
        return this.jsonLd.compact(object, this.jsonLdScope);
    }

    private Result<String> serializeMessage(Object message) {
        try {
            return Result.success((Object)this.typeManager.getMapper(this.typeContext).writeValueAsString(message));
        }
        catch (JsonProcessingException e) {
            return Result.failure((String)e.getMessage());
        }
    }
}

