/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.api.controller.v1;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.connector.dataplane.api.controller.v1.DataPlaneSignalingApi;
import org.eclipse.edc.connector.dataplane.spi.DataFlowStates;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowResponseMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowSuspendMessage;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowTerminateMessage;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1/dataflows")
public class DataPlaneSignalingApiController
implements DataPlaneSignalingApi {
    private final TypeTransformerRegistry typeTransformerRegistry;
    private final DataPlaneManager dataPlaneManager;
    private final Monitor monitor;

    public DataPlaneSignalingApiController(TypeTransformerRegistry typeTransformerRegistry, DataPlaneManager dataPlaneManager, Monitor monitor) {
        this.typeTransformerRegistry = typeTransformerRegistry;
        this.dataPlaneManager = dataPlaneManager;
        this.monitor = monitor;
    }

    @Override
    @POST
    public JsonObject start(JsonObject dataFlowStartMessage) {
        DataFlowStartMessage startMsg = (DataFlowStartMessage)((Result)this.typeTransformerRegistry.transform((Object)dataFlowStartMessage, DataFlowStartMessage.class).onFailure(f -> this.monitor.warning("Error transforming %s: %s".formatted(DataFlowStartMessage.class, f.getFailureDetail()), new Throwable[0]))).orElseThrow(InvalidRequestException::new);
        ((Result)this.dataPlaneManager.validate(startMsg).onFailure(f -> this.monitor.warning("Failed to validate request: %s".formatted(f.getFailureDetail()), new Throwable[0]))).orElseThrow(f -> f.getMessages().isEmpty() ? new InvalidRequestException("Failed to validate request: %s".formatted(startMsg.getId())) : new InvalidRequestException(f.getMessages()));
        DataFlowResponseMessage response = (DataFlowResponseMessage)this.dataPlaneManager.start(startMsg).orElseThrow(f -> new InvalidRequestException(f.getFailureDetail()));
        return (JsonObject)this.typeTransformerRegistry.transform((Object)response, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public JsonObject getTransferState(@PathParam(value="id") String transferProcessId) {
        DataFlowStates state = this.dataPlaneManager.getTransferState(transferProcessId);
        return Json.createObjectBuilder().add("@type", "DataFlowState").add("https://w3id.org/edc/v0.0.1/ns/state", state.toString()).build();
    }

    @Override
    @POST
    @Path(value="/{id}/terminate")
    public void terminate(@PathParam(value="id") String dataFlowId, JsonObject terminationMessage) {
        DataFlowTerminateMessage msg = (DataFlowTerminateMessage)((Result)this.typeTransformerRegistry.transform((Object)terminationMessage, DataFlowTerminateMessage.class).onFailure(f -> this.monitor.warning("Error transforming %s: %s".formatted(DataFlowTerminateMessage.class, f.getFailureDetail()), new Throwable[0]))).orElseThrow(InvalidRequestException::new);
        this.dataPlaneManager.terminate(dataFlowId, msg.getReason()).orElseThrow(InvalidRequestException::new);
    }

    @Override
    @POST
    @Path(value="/{id}/suspend")
    public void suspend(@PathParam(value="id") String id, JsonObject suspendMessage) {
        DataFlowSuspendMessage msg = (DataFlowSuspendMessage)((Result)this.typeTransformerRegistry.transform((Object)suspendMessage, DataFlowSuspendMessage.class).onFailure(f -> this.monitor.warning("Error transforming %s: %s".formatted(DataFlowSuspendMessage.class, f.getFailureDetail()), new Throwable[0]))).orElseThrow(InvalidRequestException::new);
        this.dataPlaneManager.suspend(id).orElseThrow(InvalidRequestException::new);
    }

    @Override
    @Path(value="/check")
    @GET
    public void checkAvailability() {
    }
}

