/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.api.controller.v1;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonObject;

@OpenAPIDefinition
@Tag(name="Data Plane Signaling api API", description="Api targeted by the Control Plane to delegate a data transfer to the Data Plane after the contract has been successfully negotiated and agreed between the two participants. ")
public interface DataPlaneSignalingApi {
    @Operation(description="Initiates a data transfer for the given start message. If the data transfer is handled by the data plane, it will be performed asynchronously. If it's a consumer-pull scenario, a data address will be returned", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=DataFlowStartMessageSchema.class))}), responses={@ApiResponse(responseCode="400", description="Failed to validate request"), @ApiResponse(responseCode="200", description="Data transfer initiated", content={@Content(schema=@Schema(implementation=DataFlowResponseMessageSchema.class))})})
    public JsonObject start(JsonObject var1);

    @Operation(description="Get the current state of a data transfer.", responses={@ApiResponse(responseCode="200", description="State of the data transfer", content={@Content(schema=@Schema(implementation=DataFlowStateSchema.class))}), @ApiResponse(responseCode="404", description="Data transfer not found in the data plane")})
    public JsonObject getTransferState(String var1);

    @Operation(description="Terminates a data transfer.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=DataFlowTerminateMessageSchema.class))}), responses={@ApiResponse(responseCode="204", description="Data transfer terminated"), @ApiResponse(responseCode="404", description="Data transfer not handled by the data plane"), @ApiResponse(responseCode="409", description="Cannot terminate the transfer")})
    public void terminate(String var1, JsonObject var2);

    @Operation(description="Suspend a data transfer.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=DataFlowSuspendMessageSchema.class))}), responses={@ApiResponse(responseCode="204", description="Data transfer suspended"), @ApiResponse(responseCode="404", description="Data transfer not handled by the data plane"), @ApiResponse(responseCode="409", description="Cannot suspend the transfer")})
    public void suspend(String var1, JsonObject var2);

    @Operation(description="Check if data plane is available.", responses={@ApiResponse(responseCode="204", description="Data plane is available")})
    public void checkAvailability();

    @Schema(name="DataFlowSuspendMessage", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowSuspendMessage\",\n    \"reason\": \"reason\"\n}\n")
    public record DataFlowSuspendMessageSchema(@Schema(name="@type", example="DataFlowSuspendMessage") String ldType, String state) {
        public static final String TERMINATE_DATA_FLOW_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowSuspendMessage\",\n    \"reason\": \"reason\"\n}\n";
    }

    @Schema(name="DataFlowTerminateMessage", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowTerminateMessage\",\n    \"reason\": \"reason\"\n}\n")
    public record DataFlowTerminateMessageSchema(@Schema(name="@type", example="DataFlowTerminateMessage") String ldType, String state) {
        public static final String TERMINATE_DATA_FLOW_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowTerminateMessage\",\n    \"reason\": \"reason\"\n}\n";
    }

    @Schema(name="DataFlowState", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowState\",\n    \"state\": \"STARTED\"\n}\n")
    public record DataFlowStateSchema(@Schema(name="@context") Object context, @Schema(name="@type", example="DataFlowState") String ldType, String state) {
        public static final String DATA_FLOW_STATE_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowState\",\n    \"state\": \"STARTED\"\n}\n";
    }

    @Schema(name="DataFlowResponseMessage", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowResponseMessage\",\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    }\n}\n")
    public record DataFlowResponseMessageSchema(@Schema(name="@context") Object context, @Schema(name="@type", example="DataFlowResponseMessage") String ldType, DataAddressSchema dataAddress) {
        public static final String DATA_FLOW_RESPONSE_MESSAGE_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"DataFlowResponseMessage\",\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    }\n}\n";
    }

    @Schema(name="DataAddress", additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    public record DataAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/DataAddress") String type, @Schema(name="type") String typeProperty) {
        public static final String DATA_ADDRESS_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/DataAddress\",\n    \"type\": \"HttpData\",\n    \"baseUrl\": \"http://example.com\"\n}\n";
    }

    @Schema(name="Properties", additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    public record FreeFormPropertiesSchema() {
    }

    @Schema(name="DataFlowStartMessage", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"transfer-id\",\n    \"@type\": \"DataFlowStartMessage\",\n    \"processId\": \"process-id\",\n    \"datasetId\": \"dataset-id\",\n    \"participantId\": \"participant-id\",\n    \"agreementId\": \"agreement-id\",\n    \"transferType\": \"HttpData-PUSH\",\n    \"sourceDataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"destinationDataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"callbackAddress\" : \"http://control-plane\",\n    \"properties\": {\n        \"key\": \"value\"\n    }\n}\n")
    public record DataFlowStartMessageSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@id") String id, @Schema(name="@type", example="DataFlowStartMessage") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String processId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String datasetId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String participantId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String agreementId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String transferType, @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/DataAddress\",\n    \"type\": \"HttpData\",\n    \"baseUrl\": \"http://example.com\"\n}\n") DataAddressSchema sourceDataAddress, @Schema(example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/DataAddress\",\n    \"type\": \"HttpData\",\n    \"baseUrl\": \"http://example.com\"\n}\n") DataAddressSchema destinationDataAddress, @Schema String callbackAddress, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) FreeFormPropertiesSchema properties) {
        public static final String DATA_FLOW_START_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"transfer-id\",\n    \"@type\": \"DataFlowStartMessage\",\n    \"processId\": \"process-id\",\n    \"datasetId\": \"dataset-id\",\n    \"participantId\": \"participant-id\",\n    \"agreementId\": \"agreement-id\",\n    \"transferType\": \"HttpData-PUSH\",\n    \"sourceDataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"destinationDataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"callbackAddress\" : \"http://control-plane\",\n    \"properties\": {\n        \"key\": \"value\"\n    }\n}\n";
    }
}

