/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.api.signaling.transform.from.JsonObjectFromDataFlowResponseMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.to.JsonObjectToDataFlowStartMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.to.JsonObjectToDataFlowSuspendMessageTransformer;
import org.eclipse.edc.connector.api.signaling.transform.to.JsonObjectToDataFlowTerminateMessageTransformer;
import org.eclipse.edc.connector.dataplane.api.controller.v1.DataPlaneSignalingApiController;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.dspace.from.JsonObjectFromDataAddressDspaceTransformer;
import org.eclipse.edc.transform.transformer.dspace.to.JsonObjectToDataAddressDspaceTransformer;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="DataPlane Signaling API extension")
public class DataPlaneSignalingApiExtension
implements ServiceExtension {
    public static final String NAME = "DataPlane Signaling API extension";
    @Inject
    private WebService webService;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private DataPlaneManager dataPlaneManager;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        TypeTransformerRegistry signalingApiTypeTransformerRegistry = this.transformerRegistry.forContext("signaling-api");
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataFlowStartMessageTransformer());
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataFlowSuspendMessageTransformer());
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataFlowTerminateMessageTransformer());
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressDspaceTransformer());
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataFlowResponseMessageTransformer(factory));
        signalingApiTypeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressDspaceTransformer(factory, jsonLdMapper));
        DataPlaneSignalingApiController controller = new DataPlaneSignalingApiController(signalingApiTypeTransformerRegistry, this.dataPlaneManager, context.getMonitor().withPrefix("SignalingAPI"));
        this.webService.registerResource("control", (Object)controller);
    }
}

