/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.spi.instance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.types.domain.DataAddress;

public class DataPlaneInstance {
    public static final String DATAPLANE_INSTANCE_TYPE = "https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance";
    public static final String TURNCOUNT = "https://w3id.org/edc/v0.0.1/ns/turnCount";
    public static final String LAST_ACTIVE = "https://w3id.org/edc/v0.0.1/ns/lastActive";
    public static final String URL = "https://w3id.org/edc/v0.0.1/ns/url";
    public static final String PROPERTIES = "https://w3id.org/edc/v0.0.1/ns/properties";
    public static final String ALLOWED_SOURCE_TYPES = "https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes";
    public static final String ALLOWED_DEST_TYPES = "https://w3id.org/edc/v0.0.1/ns/allowedDestTypes";
    private Map<String, Object> properties;
    private Set<String> allowedSourceTypes;
    private Set<String> allowedDestTypes;
    private int turnCount = 0;
    private long lastActive = Instant.now().toEpochMilli();
    private URL url = null;
    private String id;

    protected DataPlaneInstance() {
        this.properties = new HashMap<String, Object>();
        this.allowedSourceTypes = new HashSet<String>();
        this.allowedDestTypes = new HashSet<String>();
    }

    public String getId() {
        return this.id;
    }

    public boolean canHandle(DataAddress sourceAddress, DataAddress destinationAddress) {
        Objects.requireNonNull(sourceAddress, "source cannot be null!");
        Objects.requireNonNull(destinationAddress, "destination cannot be null");
        return this.allowedSourceTypes.contains(sourceAddress.getType()) && this.allowedDestTypes.contains(destinationAddress.getType());
    }

    public URL getUrl() {
        return this.url;
    }

    public int getTurnCount() {
        return this.turnCount;
    }

    public long getLastActive() {
        return this.lastActive;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getAllowedSourceTypes() {
        return Collections.unmodifiableSet(this.allowedSourceTypes);
    }

    public Set<String> getAllowedDestTypes() {
        return Collections.unmodifiableSet(this.allowedDestTypes);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final DataPlaneInstance instance = new DataPlaneInstance();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder turnCount(int turnCount) {
            this.instance.turnCount = turnCount;
            return this;
        }

        public Builder lastActive(long lastActive) {
            this.instance.lastActive = lastActive;
            return this;
        }

        public Builder id(String id) {
            this.instance.id = id;
            return this;
        }

        public Builder allowedSourceType(String type) {
            this.instance.allowedSourceTypes.add(type);
            return this;
        }

        public Builder allowedDestType(String type) {
            this.instance.allowedDestTypes.add(type);
            return this;
        }

        public Builder url(URL url) {
            this.instance.url = url;
            return this;
        }

        public Builder url(String url) {
            try {
                this.instance.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new EdcException((Throwable)e);
            }
            return this;
        }

        public DataPlaneInstance build() {
            if (this.instance.id == null) {
                this.instance.id = UUID.randomUUID().toString();
            }
            Objects.requireNonNull(this.instance.url, "DataPlaneInstance must have an URL");
            return this.instance;
        }

        public Builder property(String key, Object value) {
            this.instance.properties.put(key, value);
            return this;
        }

        public Builder allowedDestTypes(Set<String> types) {
            this.instance.allowedDestTypes = types;
            return this;
        }

        public Builder allowedSourceTypes(Set<String> types) {
            if (types != null) {
                this.instance.allowedSourceTypes = types;
            }
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.instance.properties = properties;
            return this;
        }
    }
}

