/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.spi.instance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstanceStates;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.jetbrains.annotations.Nullable;

public class DataPlaneInstance
extends StatefulEntity<DataPlaneInstance> {
    public static final String DATAPLANE_INSTANCE_TYPE = "https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance";
    @Deprecated(since="0.6.3")
    public static final String TURN_COUNT = "https://w3id.org/edc/v0.0.1/ns/turnCount";
    public static final String LAST_ACTIVE = "https://w3id.org/edc/v0.0.1/ns/lastActive";
    public static final String URL = "https://w3id.org/edc/v0.0.1/ns/url";
    public static final String PROPERTIES = "https://w3id.org/edc/v0.0.1/ns/properties";
    public static final String ALLOWED_TRANSFER_TYPES = "https://w3id.org/edc/v0.0.1/ns/allowedTransferTypes";
    public static final String ALLOWED_SOURCE_TYPES = "https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes";
    @Deprecated(since="0.7.0")
    public static final String ALLOWED_DEST_TYPES = "https://w3id.org/edc/v0.0.1/ns/allowedDestTypes";
    public static final String DATAPLANE_INSTANCE_STATE = "https://w3id.org/edc/v0.0.1/ns/state";
    public static final String DATAPLANE_INSTANCE_STATE_TIMESTAMP = "https://w3id.org/edc/v0.0.1/ns/stateTimestamp";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Set<String> allowedTransferTypes = new HashSet<String>();
    private Set<String> allowedSourceTypes = new HashSet<String>();
    @Deprecated(since="0.7.0")
    private Set<String> allowedDestTypes = new HashSet<String>();
    @Deprecated(since="0.6.3")
    private int turnCount = 0;
    private long lastActive = Instant.now().toEpochMilli();
    private URL url;

    private DataPlaneInstance() {
    }

    public DataPlaneInstance copy() {
        Builder builder = Builder.newInstance().url(this.url).lastActive(this.lastActive).turnCount(this.turnCount).allowedDestTypes(this.allowedDestTypes).allowedSourceTypes(this.allowedSourceTypes).allowedTransferType(this.allowedTransferTypes).properties(this.properties);
        return (DataPlaneInstance)this.copy(builder);
    }

    public String stateAsString() {
        return DataPlaneInstanceStates.from(this.state).name();
    }

    public boolean canHandle(DataAddress sourceAddress, @Nullable String transferType) {
        Objects.requireNonNull(sourceAddress, "source cannot be null!");
        Objects.requireNonNull(transferType, "transferType cannot be null!");
        return this.allowedSourceTypes.contains(sourceAddress.getType()) && this.allowedTransferTypes.contains(transferType);
    }

    public URL getUrl() {
        return this.url;
    }

    @Deprecated(since="0.6.3")
    public int getTurnCount() {
        return this.turnCount;
    }

    public long getLastActive() {
        return this.lastActive;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getAllowedSourceTypes() {
        return Collections.unmodifiableSet(this.allowedSourceTypes);
    }

    @Deprecated(since="0.7.0")
    public Set<String> getAllowedDestTypes() {
        return Collections.unmodifiableSet(this.allowedDestTypes);
    }

    public Set<String> getAllowedTransferTypes() {
        return Collections.unmodifiableSet(this.allowedTransferTypes);
    }

    public void transitionToRegistered() {
        this.transitionTo(DataPlaneInstanceStates.REGISTERED.code());
    }

    public void transitionToAvailable() {
        this.transitionTo(DataPlaneInstanceStates.AVAILABLE.code());
    }

    public void transitionToUnavailable() {
        this.transitionTo(DataPlaneInstanceStates.UNAVAILABLE.code());
    }

    public void transitionToUnregistered() {
        this.transitionTo(DataPlaneInstanceStates.UNREGISTERED.code());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder
    extends StatefulEntity.Builder<DataPlaneInstance, Builder> {
        private Builder(DataPlaneInstance dataPlaneInstance) {
            super((StatefulEntity)dataPlaneInstance);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder(new DataPlaneInstance());
        }

        @Deprecated(since="0.6.3")
        public Builder turnCount(int turnCount) {
            ((DataPlaneInstance)this.entity).turnCount = turnCount;
            return this;
        }

        public Builder lastActive(long lastActive) {
            ((DataPlaneInstance)this.entity).lastActive = lastActive;
            return this;
        }

        public Builder allowedSourceType(String type) {
            ((DataPlaneInstance)this.entity).allowedSourceTypes.add(type);
            return this;
        }

        public Builder allowedDestType(String type) {
            ((DataPlaneInstance)this.entity).allowedDestTypes.add(type);
            return this;
        }

        public Builder allowedTransferType(String type) {
            ((DataPlaneInstance)this.entity).allowedTransferTypes.add(type);
            return this;
        }

        public Builder url(URL url) {
            ((DataPlaneInstance)this.entity).url = url;
            return this;
        }

        public Builder url(String url) {
            try {
                ((DataPlaneInstance)this.entity).url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new EdcException((Throwable)e);
            }
            return this;
        }

        public Builder property(String key, Object value) {
            ((DataPlaneInstance)this.entity).properties.put(key, value);
            return this;
        }

        public Builder allowedDestTypes(Set<String> types) {
            ((DataPlaneInstance)this.entity).allowedDestTypes = types;
            return this;
        }

        public Builder allowedSourceTypes(Set<String> types) {
            if (types != null) {
                ((DataPlaneInstance)this.entity).allowedSourceTypes = types;
            }
            return this;
        }

        public Builder allowedTransferType(Set<String> types) {
            if (types != null) {
                ((DataPlaneInstance)this.entity).allowedTransferTypes = types;
            }
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            ((DataPlaneInstance)this.entity).properties = properties;
            return this;
        }

        public Builder self() {
            return this;
        }

        public DataPlaneInstance build() {
            Objects.requireNonNull(((DataPlaneInstance)this.entity).url, "DataPlaneInstance must have an URL");
            return (DataPlaneInstance)super.build();
        }
    }
}

