/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.control.api;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.net.URL;
import java.util.Set;
import org.eclipse.edc.api.model.ApiCoreSchema;

@OpenAPIDefinition
@Tag(name="Dataplane Selector")
public interface DataplaneSelectorControlApi {
    @Operation(method="POST", description="Register new Dataplane", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=DataPlaneInstanceSchema.class))}), responses={@ApiResponse(responseCode="200", description="Dataplane successfully registered", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Resource already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject registerDataplane(JsonObject var1);

    @Operation(method="POST", description="Unregister existing Dataplane", responses={@ApiResponse(responseCode="204", description="Dataplane successfully unregistered"), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="Resource not found", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void unregisterDataplane(String var1);

    @Operation(method="DELETE", description="Delete existing Dataplane", responses={@ApiResponse(responseCode="204", description="Dataplane successfully deleted"), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="Resource not found", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void deleteDataplane(String var1);

    @Operation(method="GET", description="Returns a list of all currently registered data plane instances", responses={@ApiResponse(responseCode="200", description="A (potentially empty) list of currently registered data plane instances", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataPlaneInstanceSchema.class)))})})
    public JsonArray getAllDataPlaneInstances();

    @Operation(method="GET", description="Returns the Data Plane Instance with the specified id.", responses={@ApiResponse(responseCode="200", description="The Data Plane Instance", content={@Content(schema=@Schema(implementation=DataPlaneInstanceSchema.class))}), @ApiResponse(responseCode="404", description="Resource not found", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject findDataPlaneById(String var1);

    @Schema(example="{\n    \"@context\": {\n        \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\"\n    },\n    \"@id\": \"your-dataplane-id\",\n    \"url\": \"http://somewhere.com:1234/api/v1\",\n    \"allowedSourceTypes\": [\n        \"source-type1\",\n        \"source-type2\"\n    ],\n    \"allowedDestTypes\": [\"your-dest-type\"],\n    \"allowedTransferTypes\": [\"transfer-type\"]\n}\n")
    public record DataPlaneInstanceSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance") String type, @Schema(name="@id", requiredMode=Schema.RequiredMode.REQUIRED) String id, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) URL url, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) Set<String> allowedSourceTypes, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) Set<String> allowedDestTypes) {
        public static final String DATAPLANE_INSTANCE_EXAMPLE = "{\n    \"@context\": {\n        \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\"\n    },\n    \"@id\": \"your-dataplane-id\",\n    \"url\": \"http://somewhere.com:1234/api/v1\",\n    \"allowedSourceTypes\": [\n        \"source-type1\",\n        \"source-type2\"\n    ],\n    \"allowedDestTypes\": [\"your-dest-type\"],\n    \"allowedTransferTypes\": [\"transfer-type\"]\n}\n";
    }
}

