/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.control.api.transformer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.dataplane.selector.control.api.model.SelectionRequest;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToSelectionRequestTransformer
extends AbstractJsonLdTransformer<JsonObject, SelectionRequest> {
    public JsonObjectToSelectionRequestTransformer() {
        super(JsonObject.class, SelectionRequest.class);
    }

    @Nullable
    public SelectionRequest transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        SelectionRequest.Builder builder = SelectionRequest.Builder.newInstance();
        this.visitProperties(jsonObject, (key, jsonValue) -> {
            switch (key) {
                case "https://w3id.org/edc/v0.0.1/ns/source": {
                    builder.source((DataAddress)this.transformObject((JsonValue)jsonValue, DataAddress.class, context));
                    break;
                }
                case "https://w3id.org/edc/v0.0.1/ns/strategy": {
                    builder.strategy(this.transformString((JsonValue)jsonValue, context));
                    break;
                }
                case "https://w3id.org/edc/v0.0.1/ns/transferType": {
                    builder.transferType(this.transformString((JsonValue)jsonValue, context));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        return builder.build();
    }
}

