/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.control.api;

import jakarta.json.Json;
import java.time.Clock;
import java.util.Map;
import org.eclipse.edc.connector.dataplane.selector.control.api.DataPlaneInstanceValidator;
import org.eclipse.edc.connector.dataplane.selector.control.api.DataplaneSelectorControlApiController;
import org.eclipse.edc.connector.dataplane.selector.control.api.transformer.JsonObjectToSelectionRequestTransformer;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromDataPlaneInstanceTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToDataAddressTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToDataPlaneInstanceTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataplane Selector Control API")
public class DataplaneSelectorControlApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataplane Selector Control API";
    @Inject
    private WebService webService;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private TypeManager typeManager;
    @Inject
    private TypeTransformerRegistry typeTransformerRegistry;
    @Inject
    private DataPlaneSelectorService dataPlaneSelectorService;
    @Inject
    private Clock clock;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance", DataPlaneInstanceValidator.instance());
        this.typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataPlaneInstanceTransformer());
        this.typeTransformerRegistry.register((TypeTransformer)new JsonObjectToSelectionRequestTransformer());
        this.typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressTransformer());
        this.typeTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(this.typeManager, "json-ld"));
        this.typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataPlaneInstanceTransformer(Json.createBuilderFactory(Map.of()), this.typeManager, "json-ld"));
        DataplaneSelectorControlApiController controller = new DataplaneSelectorControlApiController(this.validatorRegistry, this.typeTransformerRegistry, this.dataPlaneSelectorService, this.clock);
        this.webService.registerResource("control", (Object)controller);
    }
}

