/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.control.api;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.time.Clock;
import java.util.List;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.dataplane.selector.control.api.DataplaneSelectorControlApi;
import org.eclipse.edc.connector.dataplane.selector.control.api.model.SelectionRequest;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1/dataplanes")
public class DataplaneSelectorControlApiController
implements DataplaneSelectorControlApi {
    private final JsonObjectValidatorRegistry validatorRegistry;
    private final TypeTransformerRegistry transformerRegistry;
    private final DataPlaneSelectorService service;
    private final Clock clock;

    public DataplaneSelectorControlApiController(JsonObjectValidatorRegistry validatorRegistry, TypeTransformerRegistry transformerRegistry, DataPlaneSelectorService service, Clock clock) {
        this.validatorRegistry = validatorRegistry;
        this.transformerRegistry = transformerRegistry;
        this.service = service;
        this.clock = clock;
    }

    @Override
    @POST
    public JsonObject registerDataplane(JsonObject request) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance", request).orElseThrow(ValidationFailureException::new);
        DataPlaneInstance dataplane = (DataPlaneInstance)this.transformerRegistry.transform((Object)request, DataPlaneInstance.class).orElseThrow(InvalidRequestException::new);
        this.service.addInstance(dataplane).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class, (String)dataplane.getId()));
        IdResponse idResponse = IdResponse.Builder.newInstance().id(dataplane.getId()).createdAt(this.clock.millis()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)idResponse, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @PUT
    @Path(value="/{id}/unregister")
    public void unregisterDataplane(@PathParam(value="id") String id) {
        this.service.unregister(id).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public void deleteDataplane(@PathParam(value="id") String id) {
        this.service.delete(id).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
    }

    @Override
    @POST
    @Path(value="/select")
    public JsonObject selectDataplane(JsonObject request) {
        SelectionRequest selectionRequest = (SelectionRequest)this.transformerRegistry.transform((Object)request, SelectionRequest.class).orElseThrow(InvalidRequestException::new);
        DataPlaneInstance dataPlaneInstance = (DataPlaneInstance)this.service.select(selectionRequest.getSource(), selectionRequest.getTransferType(), selectionRequest.getStrategy()).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
        return (JsonObject)this.transformerRegistry.transform((Object)dataPlaneInstance, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @GET
    public JsonArray getAllDataPlaneInstances() {
        List instances = (List)this.service.getAll().orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
        return (JsonArray)instances.stream().map(i -> this.transformerRegistry.transform(i, JsonObject.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    @Override
    @GET
    @Path(value="/{id}")
    public JsonObject findDataPlaneById(@PathParam(value="id") String id) {
        DataPlaneInstance instance = (DataPlaneInstance)this.service.findById(id).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class, (String)id));
        return (JsonObject)this.transformerRegistry.transform((Object)instance, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }
}

