/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.api.v2;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.time.Clock;
import java.util.List;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.dataplane.selector.api.model.SelectionRequest;
import org.eclipse.edc.connector.dataplane.selector.api.v2.DataplaneSelectorApiV2;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v2/dataplanes")
public class DataplaneSelectorApiV2Controller
implements DataplaneSelectorApiV2 {
    private final DataPlaneSelectorService selectionService;
    private final TypeTransformerRegistry transformerRegistry;
    private final JsonObjectValidatorRegistry validatorRegistry;
    private final Clock clock;

    public DataplaneSelectorApiV2Controller(DataPlaneSelectorService selectionService, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validatorRegistry, Clock clock) {
        this.selectionService = selectionService;
        this.transformerRegistry = transformerRegistry;
        this.validatorRegistry = validatorRegistry;
        this.clock = clock;
    }

    @Override
    @POST
    @Path(value="select")
    public JsonObject selectDataPlaneInstanceV2(JsonObject requestObject) {
        SelectionRequest request = (SelectionRequest)this.transformerRegistry.transform((Object)requestObject, SelectionRequest.class).orElseThrow(InvalidRequestException::new);
        ServiceResult selection = this.selectionService.select(request.getSource(), request.getTransferType(), request.getStrategy());
        if (selection.failed()) {
            return null;
        }
        return (JsonObject)this.transformerRegistry.transform((Object)((DataPlaneInstance)selection.getContent()), JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @POST
    public JsonObject addDataPlaneInstanceV2(JsonObject jsonObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance", jsonObject).orElseThrow(ValidationFailureException::new);
        DataPlaneInstance instance = (DataPlaneInstance)this.transformerRegistry.transform((Object)jsonObject, DataPlaneInstance.class).orElseThrow(InvalidRequestException::new);
        this.selectionService.addInstance(instance).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class, (String)instance.getId()));
        IdResponse idResponse = IdResponse.Builder.newInstance().id(instance.getId()).createdAt(this.clock.millis()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)idResponse, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @GET
    public JsonArray getAllDataPlaneInstancesV2() {
        List instances = (List)this.selectionService.getAll().orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
        return (JsonArray)instances.stream().map(i -> this.transformerRegistry.transform(i, JsonObject.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }
}

