/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.api.model;

import org.eclipse.edc.spi.types.domain.DataAddress;

public class SelectionRequest {
    public static final String SELECTION_REQUEST_TYPE = "https://w3id.org/edc/v0.0.1/ns/SelectionRequest";
    public static final String SOURCE_ADDRESS = "https://w3id.org/edc/v0.0.1/ns/source";
    public static final String DEST_ADDRESS = "https://w3id.org/edc/v0.0.1/ns/destination";
    public static final String TRANSFER_TYPE = "https://w3id.org/edc/v0.0.1/ns/transferType";
    public static final String STRATEGY = "https://w3id.org/edc/v0.0.1/ns/strategy";
    private DataAddress source;
    private DataAddress destination;
    private String strategy;
    private String transferType;

    private SelectionRequest() {
    }

    public DataAddress getSource() {
        return this.source;
    }

    public DataAddress getDestination() {
        return this.destination;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public static final class Builder {
        private final SelectionRequest instance = new SelectionRequest();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder source(DataAddress source) {
            this.instance.source = source;
            return this;
        }

        public Builder destination(DataAddress destination) {
            this.instance.destination = destination;
            return this;
        }

        public Builder strategy(String strategy) {
            this.instance.strategy = strategy;
            return this;
        }

        public Builder transferType(String transferType) {
            this.instance.transferType = transferType;
            return this;
        }

        public SelectionRequest build() {
            return this.instance;
        }
    }
}

