/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.api.v3;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.eclipse.edc.connector.dataplane.selector.api.v3.DataplaneSelectorApiV3;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v3/dataplanes")
public class DataplaneSelectorApiV3Controller
implements DataplaneSelectorApiV3 {
    private final DataPlaneSelectorService selectionService;
    private final TypeTransformerRegistry transformerRegistry;

    public DataplaneSelectorApiV3Controller(DataPlaneSelectorService selectionService, TypeTransformerRegistry transformerRegistry) {
        this.selectionService = selectionService;
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    @GET
    public JsonArray getAllDataPlaneInstancesV3() {
        List instances = (List)this.selectionService.getAll().orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class));
        return (JsonArray)instances.stream().map(i -> this.transformerRegistry.transform(i, JsonObject.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }
}

