/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.transformer;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataPlaneInstanceTransformer
extends AbstractJsonLdTransformer<JsonObject, DataPlaneInstance> {
    public JsonObjectToDataPlaneInstanceTransformer() {
        super(JsonObject.class, DataPlaneInstance.class);
    }

    @Nullable
    public DataPlaneInstance transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataPlaneInstance.Builder builder = DataPlaneInstance.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)jsonObject));
        this.visitProperties(jsonObject, (key, jsonValue) -> this.transformProperties((String)key, (JsonValue)jsonValue, builder, context));
        return builder.build();
    }

    private void transformProperties(String key, JsonValue jsonValue, DataPlaneInstance.Builder builder, TransformerContext context) {
        switch (key) {
            case "https://w3id.org/edc/v0.0.1/ns/url": {
                try {
                    builder.url(new URL(Objects.requireNonNull(this.transformString(jsonValue, context))));
                }
                catch (MalformedURLException e) {
                    context.reportProblem(e.getMessage());
                }
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/lastActive": {
                this.transformLong(context, jsonValue, arg_0 -> ((DataPlaneInstance.Builder)builder).lastActive(arg_0));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/turnCount": {
                builder.turnCount(this.transformInt(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/allowedDestTypes": {
                Set set = jsonValue.asJsonArray().stream().map(jv -> this.transformString((JsonValue)jv, context)).collect(Collectors.toSet());
                builder.allowedDestTypes(set);
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes": {
                Set set = jsonValue.asJsonArray().stream().map(jv -> this.transformString((JsonValue)jv, context)).collect(Collectors.toSet());
                builder.allowedSourceTypes(set);
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/properties": {
                JsonObject props = jsonValue.asJsonArray().getJsonObject(0);
                this.visitProperties(props, (k, val) -> this.transformProperties((String)k, (JsonValue)val, builder, context));
                break;
            }
            default: {
                builder.property(key, this.transformGenericProperty(jsonValue, context));
            }
        }
    }

    private void transformLong(@NotNull TransformerContext context, JsonValue jsonValue, Consumer<Long> consumer) {
        if (jsonValue instanceof JsonArray) {
            jsonValue = jsonValue.asJsonArray().getJsonObject(0);
            consumer.accept(((JsonObject)jsonValue).getJsonNumber("@value").longValue());
        } else if (jsonValue instanceof JsonNumber) {
            consumer.accept(((JsonNumber)jsonValue).longValue());
        } else {
            context.reportProblem("Cannot convert a " + jsonValue.getValueType() + " to a long!");
        }
    }
}

