/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.api.v2;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.dataplane.selector.api.v2.DataplaneSelectorApi;
import org.eclipse.edc.connector.dataplane.selector.api.v2.model.SelectionRequest;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v2/dataplanes")
public class DataplaneSelectorApiController
implements DataplaneSelectorApi {
    private final DataPlaneSelectorService selectionService;
    private final TypeTransformerRegistry transformerRegistry;
    private final JsonObjectValidatorRegistry validatorRegistry;
    private final Clock clock;

    public DataplaneSelectorApiController(DataPlaneSelectorService selectionService, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validatorRegistry, Clock clock) {
        this.selectionService = selectionService;
        this.transformerRegistry = transformerRegistry;
        this.validatorRegistry = validatorRegistry;
        this.clock = clock;
    }

    @Override
    @POST
    @Path(value="select")
    public JsonObject find(JsonObject requestObject) {
        SelectionRequest request = (SelectionRequest)this.transformerRegistry.transform((Object)requestObject, SelectionRequest.class).orElseThrow(InvalidRequestException::new);
        DataPlaneInstance dpi = Optional.ofNullable(request.getStrategy()).map(strategy -> this.catchException(() -> this.selectionService.select(request.getSource(), request.getDestination(), strategy))).orElseGet(() -> this.catchException(() -> this.selectionService.select(request.getSource(), request.getDestination())));
        if (dpi == null) {
            return null;
        }
        return (JsonObject)this.transformerRegistry.transform((Object)dpi, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @POST
    public JsonObject addEntry(JsonObject jsonObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance", jsonObject).orElseThrow(ValidationFailureException::new);
        DataPlaneInstance instance = (DataPlaneInstance)this.transformerRegistry.transform((Object)jsonObject, DataPlaneInstance.class).orElseThrow(InvalidRequestException::new);
        this.selectionService.addInstance(instance).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class, (String)instance.getId()));
        IdResponse idResponse = IdResponse.Builder.newInstance().id(instance.getId()).createdAt(this.clock.millis()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)idResponse, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @GET
    public JsonArray getAll() {
        List instances = this.selectionService.getAll();
        return (JsonArray)instances.stream().map(i -> this.transformerRegistry.transform(i, JsonObject.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    private DataPlaneInstance catchException(Supplier<DataPlaneInstance> supplier) {
        try {
            return supplier.get();
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidRequestException(ex.getMessage());
        }
    }
}

