/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector;

import jakarta.json.Json;
import java.time.Clock;
import java.util.Map;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.connector.api.management.configuration.transform.ManagementApiTypeTransformerRegistry;
import org.eclipse.edc.connector.dataplane.selector.api.v2.DataplaneSelectorApiController;
import org.eclipse.edc.connector.dataplane.selector.api.v2.validation.DataPlaneInstanceValidator;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.selector.transformer.JsonObjectFromDataPlaneInstanceTransformer;
import org.eclipse.edc.connector.dataplane.selector.transformer.JsonObjectToDataPlaneInstanceTransformer;
import org.eclipse.edc.connector.dataplane.selector.transformer.JsonObjectToSelectionRequestTransformer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="DataPlane selector API")
public class DataPlaneSelectorApiExtension
implements ServiceExtension {
    @Inject
    private WebService webservice;
    @Inject
    private DataPlaneSelectorService selectionService;
    @Inject
    private ManagementApiConfiguration managementApiConfiguration;
    @Inject
    private TypeManager typeManager;
    @Inject
    private ManagementApiTypeTransformerRegistry transformerRegistry;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private Clock clock;

    public void initialize(ServiceExtensionContext context) {
        this.typeManager.registerTypes(new Class[]{DataPlaneInstance.class});
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance", DataPlaneInstanceValidator.instance());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToSelectionRequestTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToDataPlaneInstanceTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromDataPlaneInstanceTransformer(Json.createBuilderFactory(Map.of()), this.typeManager.getMapper("json-ld")));
        DataplaneSelectorApiController controller = new DataplaneSelectorApiController(this.selectionService, (TypeTransformerRegistry)this.transformerRegistry, this.validatorRegistry, this.clock);
        this.webservice.registerResource(this.managementApiConfiguration.getContextAlias(), (Object)controller);
    }
}

