/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.kafka.pipeline;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.eclipse.edc.connector.dataplane.kafka.config.KafkaPropertiesFactory;
import org.eclipse.edc.connector.dataplane.kafka.pipeline.KafkaDataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.validator.dataaddress.kafka.KafkaDataAddressValidator;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.jetbrains.annotations.NotNull;

public class KafkaDataSinkFactory
implements DataSinkFactory {
    private final ExecutorService executorService;
    private final Monitor monitor;
    private final KafkaPropertiesFactory propertiesFactory;
    private final Validator<DataAddress> validation;
    private final int partitionSize;

    public KafkaDataSinkFactory(ExecutorService executorService, Monitor monitor, KafkaPropertiesFactory propertiesFactory, int partitionSize) {
        this.executorService = executorService;
        this.monitor = monitor;
        this.propertiesFactory = propertiesFactory;
        this.validation = new KafkaDataAddressValidator();
        this.partitionSize = partitionSize;
    }

    public String supportedType() {
        return "Kafka";
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowStartMessage request) {
        DataAddress destination = request.getDestinationDataAddress();
        return (Result)this.validation.validate((Object)destination).flatMap(ValidationResult::toResult);
    }

    public DataSink createSink(DataFlowStartMessage request) {
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(validationResult.getFailureDetail());
        }
        DataAddress destination = request.getDestinationDataAddress();
        Properties producerProps = (Properties)this.propertiesFactory.getProducerProperties(destination.getProperties()).orElseThrow(failure -> new IllegalArgumentException(failure.getFailureDetail()));
        return ((KafkaDataSink.Builder)((KafkaDataSink.Builder)((KafkaDataSink.Builder)((KafkaDataSink.Builder)KafkaDataSink.Builder.newInstance().monitor(this.monitor)).requestId(request.getId())).topic(destination.getStringProperty("https://w3id.org/edc/v0.0.1/ns/topic")).producerProperties(producerProps).partitionSize(this.partitionSize)).executorService(this.executorService)).build();
    }
}

