/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.kafka.pipeline;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.connector.dataplane.util.sink.ParallelSink;
import org.eclipse.edc.spi.result.AbstractResult;

class KafkaDataSink
extends ParallelSink
implements Closeable {
    private String topic;
    private Producer<String, byte[]> producer;

    private KafkaDataSink() {
    }

    @Override
    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    protected StreamResult<Object> transferParts(List<DataSource.Part> parts) {
        return parts.stream().map(this::publishPart).filter(AbstractResult::failed).findFirst().orElse(StreamResult.success());
    }

    private StreamResult<Object> publishPart(DataSource.Part part) {
        StreamResult streamResult;
        block8: {
            InputStream is = part.openStream();
            try {
                this.producer.send(new ProducerRecord(this.topic, null, (Object)is.readAllBytes()), (metadata, exception) -> {
                    if (exception != null) {
                        this.monitor.warning("Failed to publish message:  " + String.valueOf(metadata), new Throwable[]{exception});
                    }
                });
                streamResult = StreamResult.success();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return StreamResult.error((String)("Failed to open part with name: " + part.name()));
                }
            }
            is.close();
        }
        return streamResult;
    }

    public static class Builder
    extends ParallelSink.Builder<Builder, KafkaDataSink> {
        private Properties producerProperties;

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
            super((ParallelSink)new KafkaDataSink());
        }

        public Builder topic(String topic) {
            ((KafkaDataSink)this.sink).topic = topic;
            return this;
        }

        public Builder producerProperties(Properties producerProperties) {
            this.producerProperties = producerProperties;
            return this;
        }

        protected void validate() {
            Objects.requireNonNull(((KafkaDataSink)this.sink).monitor, "monitor");
            Objects.requireNonNull(((KafkaDataSink)this.sink).topic, "topic");
            Objects.requireNonNull(this.producerProperties, "producerProperties");
            ((KafkaDataSink)this.sink).producer = new KafkaProducer(this.producerProperties);
        }
    }
}

