/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.kafka.config;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.edc.spi.result.Result;

public class KafkaPropertiesFactory {
    public Result<Properties> getConsumerProperties(Map<String, Object> properties) {
        return (Result)this.getCommonProperties(properties).map(props -> {
            props.put("key.deserializer", StringDeserializer.class.getName());
            props.put("value.deserializer", ByteArrayDeserializer.class.getName());
            return props;
        });
    }

    public Result<Properties> getProducerProperties(Map<String, Object> properties) {
        return (Result)this.getCommonProperties(properties).map(props -> {
            props.put("key.serializer", StringSerializer.class.getName());
            props.put("value.serializer", ByteArraySerializer.class.getName());
            return props;
        });
    }

    private Result<Properties> getCommonProperties(Map<String, Object> properties) {
        Properties props = new Properties();
        properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("https://w3id.org/edc/v0.0.1/ns/kafka.")).forEach(entry -> props.put(((String)entry.getKey()).replaceFirst(Pattern.quote("https://w3id.org/edc/v0.0.1/ns/kafka."), ""), entry.getValue()));
        return Result.success((Object)props);
    }
}

