/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.kafka;

import java.time.Clock;
import org.eclipse.edc.connector.dataplane.kafka.config.KafkaPropertiesFactory;
import org.eclipse.edc.connector.dataplane.kafka.pipeline.KafkaDataSinkFactory;
import org.eclipse.edc.connector.dataplane.kafka.pipeline.KafkaDataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataTransferExecutorServiceContainer;
import org.eclipse.edc.connector.dataplane.spi.pipeline.PipelineService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

@Extension(value="Data Plane Kafka")
public class DataPlaneKafkaExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane Kafka";
    private static final int DEFAULT_PARTITION_SIZE = 5;
    @Setting(value="The partitionSize used by the kafka data sink", type="int", defaultValue="5", min=1L)
    private static final String EDC_DATAPLANE_KAFKA_SINK_PARTITION_SIZE = "edc.dataplane.kafka.sink.partition.size";
    @Inject
    private DataTransferExecutorServiceContainer executorContainer;
    @Inject
    private PipelineService pipelineService;
    @Inject
    private Clock clock;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        KafkaPropertiesFactory propertiesFactory = new KafkaPropertiesFactory();
        int sinkPartitionSize = context.getSetting(EDC_DATAPLANE_KAFKA_SINK_PARTITION_SIZE, 5);
        this.pipelineService.registerFactory((DataSourceFactory)new KafkaDataSourceFactory(monitor, propertiesFactory, this.clock));
        this.pipelineService.registerFactory((DataSinkFactory)new KafkaDataSinkFactory(this.executorContainer.getExecutorService(), monitor, propertiesFactory, sinkPartitionSize));
    }
}

