/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.store.sql;

import org.eclipse.edc.connector.dataplane.selector.spi.store.DataPlaneInstanceStore;
import org.eclipse.edc.connector.dataplane.selector.store.sql.SqlDataPlaneInstanceStore;
import org.eclipse.edc.connector.dataplane.selector.store.sql.schema.DataPlaneInstanceStatements;
import org.eclipse.edc.connector.dataplane.selector.store.sql.schema.postgres.PostgresDataPlaneInstanceStatements;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={DataPlaneInstanceStore.class})
@Extension(value="Sql Data Plane Instance Store")
public class SqlDataPlaneInstanceStoreExtension
implements ServiceExtension {
    public static final String NAME = "Sql Data Plane Instance Store";
    @Setting(value="Name of the datasource to use for accessing data plane instances")
    public static final String DATASOURCE_SETTING_NAME = "edc.datasource.dataplaneinstance.name";
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject(required=false)
    private DataPlaneInstanceStatements statements;
    @Inject
    private TypeManager typeManager;
    @Inject
    private QueryExecutor queryExecutor;

    public String name() {
        return NAME;
    }

    @Provider
    public DataPlaneInstanceStore dataPlaneInstanceStore(ServiceExtensionContext context) {
        return new SqlDataPlaneInstanceStore(this.dataSourceRegistry, this.getDataSourceName(context), this.transactionContext, this.getStatementImpl(), this.typeManager.getMapper(), this.queryExecutor);
    }

    private DataPlaneInstanceStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDataPlaneInstanceStatements();
    }

    private String getDataSourceName(ServiceExtensionContext context) {
        return context.getConfig().getString(DATASOURCE_SETTING_NAME, "default");
    }
}

