/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.store.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.selector.spi.store.DataPlaneInstanceStore;
import org.eclipse.edc.connector.dataplane.selector.store.sql.schema.DataPlaneInstanceStatements;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class SqlDataPlaneInstanceStore
extends AbstractSqlStore
implements DataPlaneInstanceStore {
    private final DataPlaneInstanceStatements statements;

    public SqlDataPlaneInstanceStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, DataPlaneInstanceStatements statements, ObjectMapper objectMapper, QueryExecutor queryExecutor) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = Objects.requireNonNull(statements);
    }

    public StoreResult<Void> create(DataPlaneInstance instance) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, instance.getId()) == null) {
                    this.insert(connection, instance);
                    StoreResult storeResult2 = StoreResult.success();
                    return storeResult2;
                }
                StoreResult storeResult = StoreResult.alreadyExists((String)String.format("Data Plane Instance with ID %s already exists", instance.getId()));
                return storeResult;
            }
            catch (Exception exception) {
                throw new EdcPersistenceException((Throwable)exception);
            }
        });
    }

    public StoreResult<Void> update(DataPlaneInstance instance) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, instance.getId()) == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)String.format("Data Plane Instance with ID %s not found", instance.getId()));
                    return storeResult2;
                }
                this.update(connection, instance);
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (Exception exception) {
                throw new EdcPersistenceException((Throwable)exception);
            }
        });
    }

    public DataPlaneInstance findById(String id) {
        Objects.requireNonNull(id);
        return (DataPlaneInstance)this.transactionContext.execute(() -> {
            DataPlaneInstance dataPlaneInstance;
            block8: {
                Connection connection = this.getConnection();
                try {
                    dataPlaneInstance = this.findByIdInternal(connection, id);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw new EdcPersistenceException((Throwable)exception);
                    }
                }
                connection.close();
            }
            return dataPlaneInstance;
        });
    }

    public Stream<DataPlaneInstance> getAll() {
        try {
            String sql = this.statements.getAllTemplate();
            return this.queryExecutor.query(this.getConnection(), true, this::mapResultSet, sql, new Object[0]);
        }
        catch (SQLException exception) {
            throw new EdcPersistenceException((Throwable)exception);
        }
    }

    private DataPlaneInstance findByIdInternal(Connection connection, String id) {
        String sql = this.statements.getFindByIdTemplate();
        return (DataPlaneInstance)this.queryExecutor.single(connection, false, this::mapResultSet, sql, new Object[]{id});
    }

    private void insert(Connection connection, DataPlaneInstance instance) {
        String sql = this.statements.getInsertTemplate();
        this.queryExecutor.execute(connection, sql, new Object[]{instance.getId(), this.toJson(instance)});
    }

    private void update(Connection connection, DataPlaneInstance instance) {
        String sql = this.statements.getUpdateTemplate();
        this.queryExecutor.execute(connection, sql, new Object[]{this.toJson(instance), instance.getId()});
    }

    private DataPlaneInstance mapResultSet(ResultSet resultSet) throws Exception {
        String json = resultSet.getString(this.statements.getDataColumn());
        return (DataPlaneInstance)this.fromJson(json, DataPlaneInstance.class);
    }
}

