/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.connector.dataplane.http.params.HttpRequestFactory;
import org.eclipse.edc.connector.dataplane.http.pipeline.HttpPart;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.http.spi.EdcHttpClient;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;

public class HttpDataSource
implements DataSource {
    private static final int FORBIDDEN = 401;
    private static final int NOT_AUTHORIZED = 403;
    private static final int NOT_FOUND = 404;
    private String name;
    private HttpRequestParams params;
    private String requestId;
    private Monitor monitor;
    private EdcHttpClient httpClient;
    private HttpRequestFactory requestFactory;
    private final AtomicReference<ResponseBodyStream> responseBodyStream = new AtomicReference();

    private HttpDataSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamResult<Stream<DataSource.Part>> openPartStream() {
        Request request = this.requestFactory.toRequest(this.params);
        this.monitor.debug(() -> "Executing HTTP request: " + request.url(), new Throwable[0]);
        try {
            Response response;
            block17: {
                block16: {
                    StreamResult streamResult;
                    response = this.httpClient.execute(request);
                    if (response.isSuccessful()) {
                        ResponseBody body = response.body();
                        if (body == null) {
                            throw new EdcException(String.format("Received empty response body transferring HTTP data for request %s: %s", this.requestId, response.code()));
                        }
                        InputStream stream = body.byteStream();
                        this.responseBodyStream.set(new ResponseBodyStream(body, stream));
                        String mediaType = Optional.ofNullable(body.contentType()).map(MediaType::toString).orElse("application/octet-stream");
                        return StreamResult.success(Stream.of(new HttpPart(this.name, stream, mediaType)));
                    }
                    try {
                        if (403 != response.code() && 401 != response.code()) break block16;
                        streamResult = StreamResult.notAuthorized();
                    }
                    catch (Throwable throwable) {
                        try {
                            response.close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.monitor.info("Error closing failed response", new Throwable[]{e});
                        }
                        throw throwable;
                    }
                    try {
                        response.close();
                        return streamResult;
                    }
                    catch (Exception e) {
                        this.monitor.info("Error closing failed response", new Throwable[]{e});
                    }
                    return streamResult;
                }
                if (404 != response.code()) break block17;
                StreamResult streamResult = StreamResult.notFound();
                try {
                    response.close();
                    return streamResult;
                }
                catch (Exception e) {
                    this.monitor.info("Error closing failed response", new Throwable[]{e});
                }
                return streamResult;
            }
            StreamResult streamResult = StreamResult.error((String)String.format("Received code transferring HTTP data: %s - %s.", response.code(), response.message()));
            try {
                response.close();
                return streamResult;
            }
            catch (Exception e) {
                this.monitor.info("Error closing failed response", new Throwable[]{e});
            }
            return streamResult;
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public void close() {
        ResponseBodyStream bodyStream = this.responseBodyStream.get();
        if (bodyStream != null) {
            bodyStream.responseBody().close();
            try {
                bodyStream.stream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private record ResponseBodyStream(ResponseBody responseBody, InputStream stream) {
    }

    public static class Builder {
        private final HttpDataSource dataSource = new HttpDataSource();

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder params(HttpRequestParams params) {
            this.dataSource.params = params;
            return this;
        }

        public Builder name(String name) {
            this.dataSource.name = name;
            return this;
        }

        public Builder requestId(String requestId) {
            this.dataSource.requestId = requestId;
            return this;
        }

        public Builder httpClient(EdcHttpClient httpClient) {
            this.dataSource.httpClient = httpClient;
            return this;
        }

        public Builder monitor(Monitor monitor) {
            this.dataSource.monitor = monitor;
            return this;
        }

        public Builder requestFactory(HttpRequestFactory requestFactory) {
            this.dataSource.requestFactory = requestFactory;
            return this;
        }

        public HttpDataSource build() {
            Objects.requireNonNull(this.dataSource.requestId, "requestId");
            Objects.requireNonNull(this.dataSource.httpClient, "httpClient");
            Objects.requireNonNull(this.dataSource.monitor, "monitor");
            Objects.requireNonNull(this.dataSource.requestFactory, "requestFactory");
            return this.dataSource;
        }
    }
}

