/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.edc.connector.dataplane.http.params.HttpRequestFactory;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.connector.dataplane.util.sink.ParallelSink;
import org.eclipse.edc.spi.http.EdcHttpClient;

public class HttpDataSink
extends ParallelSink {
    private static final StreamResult<Void> ERROR_WRITING_DATA = StreamResult.error((String)"Error writing data");
    private HttpRequestParams params;
    private EdcHttpClient httpClient;
    private HttpRequestFactory requestFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StreamResult<Void> transferParts(List<DataSource.Part> parts) {
        Iterator<DataSource.Part> iterator = parts.iterator();
        if (!iterator.hasNext()) return StreamResult.success();
        DataSource.Part part = iterator.next();
        Request request = this.requestFactory.toRequest(this.params, () -> ((DataSource.Part)part).openStream());
        try (Response response = this.httpClient.execute(request);){
            if (!response.isSuccessful()) {
                this.monitor.severe(String.format("Error {%s: %s} received writing HTTP data %s to endpoint %s for request: %s", response.code(), response.message(), part.name(), request.url().url(), request), new Throwable[0]);
                StreamResult<Void> streamResult2 = ERROR_WRITING_DATA;
                return streamResult2;
            }
            StreamResult streamResult = StreamResult.success();
            return streamResult;
        }
        catch (Exception e) {
            this.monitor.severe(String.format("Error writing HTTP data %s to endpoint %s for request: %s", part.name(), request.url().url(), request), new Throwable[]{e});
            return ERROR_WRITING_DATA;
        }
    }

    private HttpDataSink() {
    }

    public static class Builder
    extends ParallelSink.Builder<Builder, HttpDataSink> {
        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
            super((ParallelSink)new HttpDataSink());
        }

        public Builder params(HttpRequestParams params) {
            ((HttpDataSink)this.sink).params = params;
            return this;
        }

        public Builder httpClient(EdcHttpClient httpClient) {
            ((HttpDataSink)this.sink).httpClient = httpClient;
            return this;
        }

        public Builder requestFactory(HttpRequestFactory requestFactory) {
            ((HttpDataSink)this.sink).requestFactory = requestFactory;
            return this;
        }

        protected void validate() {
            Objects.requireNonNull(((HttpDataSink)this.sink).requestFactory, "requestFactory");
        }
    }
}

