/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.params.decorators;

import java.util.Map;
import java.util.Optional;
import org.eclipse.edc.connector.dataplane.http.spi.HttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.HttpDataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;

public class BaseCommonHttpParamsDecorator
implements HttpParamsDecorator {
    private final Vault vault;
    private final TypeManager typeManager;

    public BaseCommonHttpParamsDecorator(Vault vault, TypeManager typeManager) {
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public HttpRequestParams.Builder decorate(DataFlowRequest request, HttpDataAddress address, HttpRequestParams.Builder params) {
        String requestId = request.getId();
        String baseUrl = Optional.ofNullable(address.getBaseUrl()).orElseThrow(() -> new EdcException(String.format("DataFlowRequest %s: 'baseUrl' property is missing in HttpDataAddress", requestId)));
        Optional.ofNullable(address.getAuthKey()).ifPresent(authKey -> params.header(authKey, this.extractAuthCode(requestId, address)));
        return params.baseUrl(baseUrl).headers(address.getAdditionalHeaders());
    }

    private String extractAuthCode(String requestId, HttpDataAddress address) {
        String secret = address.getAuthCode();
        if (secret != null) {
            return secret;
        }
        String secretName = address.getSecretName();
        if (secretName == null) {
            throw new EdcException(String.format("DataFlowRequest %s: 'secretName' property is missing in HttpDataAddress", requestId));
        }
        String value = this.vault.resolveSecret(secretName);
        return Optional.ofNullable(value).map(it -> this.getTokenFromJson((String)it, requestId).orElse((String)it)).orElseThrow(() -> new EdcException(String.format("DataFlowRequest %s: no secret found in vault with name %s", requestId, secretName)));
    }

    private Optional<String> getTokenFromJson(String value, String requestId) {
        Map map;
        try {
            map = (Map)this.typeManager.readValue(value, Map.class);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        Object token = map.get("token");
        if (token == null) {
            throw new EdcException(String.format("DataFlowRequest %s: Field 'token' not found in the secret serialized as json: %s", requestId, value));
        }
        return Optional.of(token.toString());
    }
}

