/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.params;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.connector.dataplane.http.params.decorators.BaseCommonHttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.params.decorators.BaseSinkHttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.params.decorators.BaseSourceHttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.spi.HttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParamsProvider;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.HttpDataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;

public class HttpRequestParamsProviderImpl
implements HttpRequestParamsProvider {
    private final List<HttpParamsDecorator> sourceDecorators = new ArrayList<HttpParamsDecorator>();
    private final List<HttpParamsDecorator> sinkDecorators = new ArrayList<HttpParamsDecorator>();

    public HttpRequestParamsProviderImpl(Vault vault, TypeManager typeManager) {
        BaseCommonHttpParamsDecorator commonHttpParamsDecorator = new BaseCommonHttpParamsDecorator(vault, typeManager);
        this.registerSinkDecorator(commonHttpParamsDecorator);
        this.registerSourceDecorator(commonHttpParamsDecorator);
        this.registerSourceDecorator(new BaseSourceHttpParamsDecorator());
        this.registerSinkDecorator(new BaseSinkHttpParamsDecorator());
    }

    public void registerSourceDecorator(HttpParamsDecorator decorator) {
        this.sourceDecorators.add(decorator);
    }

    public void registerSinkDecorator(HttpParamsDecorator decorator) {
        this.sinkDecorators.add(decorator);
    }

    public HttpRequestParams provideSourceParams(DataFlowRequest request) {
        HttpRequestParams.Builder params = HttpRequestParams.Builder.newInstance();
        HttpDataAddress address = HttpDataAddress.Builder.newInstance().copyFrom(request.getSourceDataAddress()).build();
        this.sourceDecorators.forEach(decorator -> decorator.decorate(request, address, params));
        return params.build();
    }

    public HttpRequestParams provideSinkParams(DataFlowRequest request) {
        HttpRequestParams.Builder params = HttpRequestParams.Builder.newInstance();
        HttpDataAddress address = HttpDataAddress.Builder.newInstance().copyFrom(request.getDestinationDataAddress()).build();
        this.sinkDecorators.forEach(decorator -> decorator.decorate(request, address, params));
        return params.build();
    }
}

