/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import java.util.concurrent.ExecutorService;
import org.eclipse.edc.connector.dataplane.http.params.HttpRequestFactory;
import org.eclipse.edc.connector.dataplane.http.pipeline.HttpDataSink;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParamsProvider;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class HttpDataSinkFactory
implements DataSinkFactory {
    private final EdcHttpClient httpClient;
    private final ExecutorService executorService;
    private final int partitionSize;
    private final Monitor monitor;
    private final HttpRequestParamsProvider requestParamsProvider;
    private final HttpRequestFactory requestFactory;

    public HttpDataSinkFactory(EdcHttpClient httpClient, ExecutorService executorService, int partitionSize, Monitor monitor, HttpRequestParamsProvider requestParamsProvider, HttpRequestFactory requestFactory) {
        this.httpClient = httpClient;
        this.executorService = executorService;
        this.partitionSize = partitionSize;
        this.monitor = monitor;
        this.requestParamsProvider = requestParamsProvider;
        this.requestFactory = requestFactory;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "HttpData".equals(request.getDestinationDataAddress().getType());
    }

    @NotNull
    public Result<Boolean> validate(DataFlowRequest request) {
        return (Result)this.validateRequest(request).map(it -> true);
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        try {
            this.createSink(request);
        }
        catch (Exception e) {
            return Result.failure((String)("Failed to build HttpDataSink: " + e.getMessage()));
        }
        return Result.success();
    }

    public DataSink createSink(DataFlowRequest request) {
        return ((HttpDataSink.Builder)((HttpDataSink.Builder)((HttpDataSink.Builder)((HttpDataSink.Builder)HttpDataSink.Builder.newInstance().params(this.requestParamsProvider.provideSinkParams(request)).requestId(request.getId())).partitionSize(this.partitionSize)).httpClient(this.httpClient).executorService(this.executorService)).monitor(this.monitor)).requestFactory(this.requestFactory).build();
    }
}

