/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import okio.BufferedSink;
import org.eclipse.edc.connector.dataplane.http.pipeline.AbstractTransferRequestBody;
import org.jetbrains.annotations.NotNull;

public class ChunkedTransferRequestBody
extends AbstractTransferRequestBody {
    private final Supplier<InputStream> bodySupplier;

    public ChunkedTransferRequestBody(Supplier<InputStream> bodySupplier, String contentType) {
        super(contentType);
        this.bodySupplier = bodySupplier;
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        try (OutputStream os = sink.outputStream();
             InputStream is = this.bodySupplier.get();){
            is.transferTo(os);
        }
    }
}

