/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.params;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.edc.connector.dataplane.http.pipeline.ChunkedTransferRequestBody;
import org.eclipse.edc.connector.dataplane.http.pipeline.NonChunkedTransferRequestBody;
import org.eclipse.edc.connector.dataplane.http.pipeline.StringRequestBodySupplier;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.util.string.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestFactory {
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\";

    public Request toRequest(HttpRequestParams params) {
        StringRequestBodySupplier bodySupplier = Optional.of(params).map(HttpRequestParams::getBody).map(StringRequestBodySupplier::new).orElse(null);
        return this.toRequest(params, bodySupplier);
    }

    public Request toRequest(HttpRequestParams params, Supplier<InputStream> bodySupplier) {
        RequestBody requestBody = this.createRequestBody(params, bodySupplier);
        Request.Builder requestBuilder = new Request.Builder().url(this.toUrl(params)).method(params.getMethod(), requestBody);
        params.getHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        return requestBuilder.build();
    }

    @Nullable
    private RequestBody createRequestBody(HttpRequestParams params, @Nullable Supplier<InputStream> bodySupplier) {
        String contentType = params.getContentType();
        if (bodySupplier == null || contentType == null) {
            return null;
        }
        return params.isNonChunkedTransfer() ? new NonChunkedTransferRequestBody(bodySupplier, contentType) : new ChunkedTransferRequestBody(bodySupplier, contentType);
    }

    private HttpUrl toUrl(HttpRequestParams params) {
        String queryParams;
        String baseUrl = params.getBaseUrl();
        HttpUrl parsedBaseUrl = HttpUrl.parse((String)baseUrl);
        Objects.requireNonNull(parsedBaseUrl, "Failed to parse baseUrl: " + baseUrl);
        HttpUrl.Builder builder = parsedBaseUrl.newBuilder();
        String path = params.getPath();
        if (!StringUtils.isNullOrBlank((String)path)) {
            String sanitizedPath = HttpRequestFactory.startWithSlash(path) ? path.substring(1) : path;
            builder.addPathSegments(sanitizedPath);
        }
        if (!StringUtils.isNullOrBlank((String)(queryParams = params.getQueryParams()))) {
            builder.query(queryParams);
        }
        return builder.build();
    }

    private static boolean startWithSlash(@NotNull String s) {
        return s.startsWith(SLASH) || s.startsWith(BACKSLASH);
    }
}

