/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import org.eclipse.edc.connector.dataplane.http.params.HttpRequestFactory;
import org.eclipse.edc.connector.dataplane.http.pipeline.HttpDataSource;
import org.eclipse.edc.connector.dataplane.http.spi.HttpDataAddress;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParamsProvider;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.http.spi.EdcHttpClient;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.jetbrains.annotations.NotNull;

public class HttpDataSourceFactory
implements DataSourceFactory {
    private final EdcHttpClient httpClient;
    private final HttpRequestParamsProvider requestParamsProvider;
    private final Monitor monitor;
    private final HttpRequestFactory requestFactory;

    public HttpDataSourceFactory(EdcHttpClient httpClient, HttpRequestParamsProvider requestParamsProvider, Monitor monitor, HttpRequestFactory requestFactory) {
        this.httpClient = httpClient;
        this.requestParamsProvider = requestParamsProvider;
        this.monitor = monitor;
        this.requestFactory = requestFactory;
    }

    public String supportedType() {
        return "HttpData";
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowStartMessage request) {
        try {
            this.createSource(request);
        }
        catch (Exception e) {
            return Result.failure((String)("Failed to build HttpDataSource: " + e.getMessage()));
        }
        return Result.success();
    }

    public DataSource createSource(DataFlowStartMessage request) {
        HttpDataAddress dataAddress = HttpDataAddress.Builder.newInstance().copyFrom(request.getSourceDataAddress()).build();
        return HttpDataSource.Builder.newInstance().httpClient(this.httpClient).monitor(this.monitor).requestId(request.getId()).name(dataAddress.getName()).params(this.requestParamsProvider.provideSourceParams(request)).requestFactory(this.requestFactory).build();
    }
}

