/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http;

import org.eclipse.edc.connector.dataplane.http.params.HttpRequestFactory;
import org.eclipse.edc.connector.dataplane.http.params.HttpRequestParamsProviderImpl;
import org.eclipse.edc.connector.dataplane.http.pipeline.HttpDataSinkFactory;
import org.eclipse.edc.connector.dataplane.http.pipeline.HttpDataSourceFactory;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParamsProvider;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataTransferExecutorServiceContainer;
import org.eclipse.edc.connector.dataplane.spi.pipeline.PipelineService;
import org.eclipse.edc.http.spi.EdcHttpClient;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Provides(value={HttpRequestParamsProvider.class})
@Extension(value="Data Plane HTTP")
public class DataPlaneHttpExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane HTTP";
    private static final int DEFAULT_PARTITION_SIZE = 5;
    @Setting(description="Number of partitions for parallel message push in the HttpDataSink", defaultValue="5", key="edc.dataplane.http.sink.partition.size")
    private int partitionSize;
    @Inject
    private EdcHttpClient httpClient;
    @Inject
    private PipelineService pipelineService;
    @Inject
    private DataTransferExecutorServiceContainer executorContainer;
    @Inject
    private Vault vault;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        HttpRequestParamsProviderImpl paramsProvider = new HttpRequestParamsProviderImpl(this.vault, this.typeManager);
        context.registerService(HttpRequestParamsProvider.class, (Object)paramsProvider);
        HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
        HttpDataSourceFactory sourceFactory = new HttpDataSourceFactory(this.httpClient, paramsProvider, monitor, httpRequestFactory);
        this.pipelineService.registerFactory((DataSourceFactory)sourceFactory);
        HttpDataSinkFactory sinkFactory = new HttpDataSinkFactory(this.httpClient, this.executorContainer.getExecutorService(), this.partitionSize, monitor, paramsProvider, httpRequestFactory);
        this.pipelineService.registerFactory((DataSinkFactory)sinkFactory);
    }
}

