/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.pipeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import okio.BufferedSink;
import org.eclipse.edc.connector.dataplane.http.pipeline.AbstractTransferRequestBody;
import org.jetbrains.annotations.NotNull;

public class NonChunkedTransferRequestBody
extends AbstractTransferRequestBody {
    private byte[] bytes;

    public NonChunkedTransferRequestBody(Supplier<InputStream> contentSupplier, String contentType) {
        super(contentType);
        try (InputStream is = contentSupplier.get();){
            this.bytes = is.readAllBytes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long contentLength() {
        return this.bytes == null ? 0L : (long)this.bytes.length;
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        if (this.bytes == null) {
            return;
        }
        try (OutputStream os = sink.outputStream();){
            os.write(this.bytes);
        }
    }
}

