/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.params.decorators;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.connector.dataplane.http.spi.HttpDataAddress;
import org.eclipse.edc.connector.dataplane.http.spi.HttpParamsDecorator;
import org.eclipse.edc.connector.dataplane.http.spi.HttpRequestParams;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.FlowType;
import org.eclipse.edc.util.string.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSourceHttpParamsDecorator
implements HttpParamsDecorator {
    private static final String DEFAULT_METHOD = "GET";

    public HttpRequestParams.Builder decorate(DataFlowStartMessage request, HttpDataAddress address, HttpRequestParams.Builder params) {
        params.method(this.extractMethod(address, request));
        params.path(this.extractPath(address, request));
        params.queryParams(this.extractQueryParams(address, request));
        Optional.ofNullable(this.extractContentType(address, request)).ifPresent(ct -> {
            params.contentType(ct);
            params.body(this.extractBody(address, request));
        });
        params.nonChunkedTransfer(false);
        return params;
    }

    @NotNull
    private String extractMethod(HttpDataAddress address, DataFlowStartMessage request) {
        if (Boolean.parseBoolean(address.getProxyMethod()) && FlowType.PULL.equals((Object)request.getFlowType())) {
            return Optional.ofNullable((String)request.getProperties().get("method")).orElseThrow(() -> new EdcException(String.format("DataFlowRequest %s: 'method' property is missing", request.getId())));
        }
        return Optional.ofNullable(address.getMethod()).orElse(DEFAULT_METHOD);
    }

    @Nullable
    private String extractPath(HttpDataAddress address, DataFlowStartMessage request) {
        return Boolean.parseBoolean(address.getProxyPath()) ? (String)request.getProperties().get("pathSegments") : address.getPath();
    }

    @Nullable
    private String extractQueryParams(HttpDataAddress address, DataFlowStartMessage request) {
        String queryParams = Stream.of(address.getQueryParams(), this.getRequestQueryParams(address, request)).filter(s -> !StringUtils.isNullOrBlank((String)s)).collect(Collectors.joining("&"));
        return !queryParams.isEmpty() ? queryParams : null;
    }

    @Nullable
    private String extractContentType(HttpDataAddress address, DataFlowStartMessage request) {
        return Boolean.parseBoolean(address.getProxyBody()) ? (String)request.getProperties().get("mediaType") : address.getContentType();
    }

    @Nullable
    private String extractBody(HttpDataAddress address, DataFlowStartMessage request) {
        return Boolean.parseBoolean(address.getProxyBody()) ? (String)request.getProperties().get("body") : null;
    }

    @Nullable
    private String getRequestQueryParams(HttpDataAddress address, DataFlowStartMessage request) {
        return Boolean.parseBoolean(address.getProxyQueryParams()) ? (String)request.getProperties().get("queryParams") : null;
    }
}

